<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/driver/get_status",
 *     tags={"Driver Profile"},
 *     summary="Get the driver's online status.",
 *     operationId="driverStatus",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 * 
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/GetDriverStatusResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * @OA\Schema(
 *   schema="GetDriverStatusResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="integer",
 *              
 *          )
 *      )
 *   }
 * )
 * 
 */

 class GetDriverStatus { }