<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/get_current_booking_details",
 *     tags={"Booking Module"},
 *     summary="Get the current booking request.",
 *     operationId="getCurrentBookingDetails",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetCurrentBookingDetailsResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetCurrentBookingDetailsResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/GetCurrentBookingDetailData"
 *              
 *          ),
 *          @OA\Property(
 *              property="is_occupied", 
 *              type="integer",
 *              
 *          )
 *      )
 *   }
 * )
 */

 class GetCurrentBookingDetails { }