<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/get_air_booking_details",
 *     tags={"Air Transportation Module"},
 *     summary="Get the user air booking details.",
 *     operationId="getAirBookingDetail",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "id",
 *                      },
 *                 @OA\Property(
 *                     property="id", 
 *                     type="integer",
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetAirTransportBookingDetailResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetAirTransportBookingDetailResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/GetAirTransportBookingDetailData"
 *          )
 *      )
 *   }
 * )
 */

 class GetAirTransportBookingDetail { }