<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/get_air_tranport_bookings",
 *     tags={"Air Transportation Module"},
 *     summary="Get the user air transport booking quotes.",
 *     operationId="getBookings",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"status","offset","page"},
 *                 @OA\Property(
 *                     property="status", 
 *                     type="integer",
 *                     description="1=pending, 2=upcoming, 3=completed, 4=cancelled"
 *                 ),
 *                 @OA\Property(
 *                     property="offset", 
 *                     type="integer",
 *                     
 *                 ),
 *                @OA\Property(
 *                     property="page", 
 *                     type="integer",
 *                    
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetAirTransportBookingResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetAirTransportBookingResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *          @OA\Items(
 *              ref="#/components/schemas/GetAirTransportBookingData"
 *              )
 *          ),
 *          @OA\Property(
 *              property="pagination", 
 *              type="object",
 *              ref="#/components/schemas/PaginationResponseObjectFields"
 *          ),
 *      )
 *   }
 * )
 */

 class GetAirTransportBooking { }