<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/user/get_address_with_type",
 *     tags={"User Addresses"},
 *     summary="Get the user address with given type.",
 *     operationId="getAddressWithType",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "type",
 *                      },
 *                 @OA\Property(
 *                     property="type", 
 *                     type="integer",
 *                     description="1 = home, 2 = office, 3 = other",
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetAddressWithTypeResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetAddressWithTypeResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *              @OA\Items(
 *                  type="object",
 *                  ref="#/components/schemas/GetAddressData"
 *              ),
 *              
 *          )
 *      )
 *   }
 * )
 */

 class GetAddressWithType { }