<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/password/email",
 *     tags={"User Authentication"},
 *     summary="Send the reset password link or OTP email to user.",
 *     operationId="forgotPassword",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"email","user_type"},
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="user_type", 
 *                     type="integer",
 *                     description= "1 = customer, 2 = driver"
 *                 ),
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class ForgotPassword { }