<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/get_faqs/{type}",
 *     tags={"Settings"},
 *     summary="Get faq data.",
 *     operationId="faqData",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="type",
 *         description="1 = user, 2 = driver",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="integer",
 *              
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/FaqResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 *@OA\Schema(
 *   schema="FaqResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *              @OA\Items(
 *                  type="object",
 *                  ref="#/components/schemas/FaqData"
 *              )
 *          )
 *      )
 *   }
 * )
 */

 class Faq { }