<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/export_earning_data",
 *     tags={"Booking Module"},
 *     summary="Export the driver booking earning data.",
 *     operationId="exportEarningData",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             
 *             @OA\Schema(
 *                  required={
 *                        "filter_type",
 *                        "export_type"
 *                      },
 *                 @OA\Property(
 *                     property="filter_type", 
 *                     type="integer",
 *                     description="1 = weekly, 2 = monthly, 3 = yearly, 4=range",
 *                 ),
 *                 @OA\Property(
 *                     property="filter_option", 
 *                     type="integer",
 *                     description="1 = pending, 2 = received",
 *                 ),
 *                 @OA\Property(
 *                     property="export_type", 
 *                     type="integer",
 *                     description ="1=csv,2=pdf"
 *                 ),
 *                 @OA\Property(
 *                     property="from_date", 
 *                     type="string",
 *                     description ="2023-10-01"
 *                 ),
 *                 @OA\Property(
 *                     property="to_date", 
 *                     type="string",
 *                     description ="2023-10-13"
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/ExportEarningDataResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="ExportEarningDataResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="url", 
 *              type="string",            
 *          )
 *      )
 *   }
 * )
 */

class ExportEarningData
{
}