<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/register",
 *     tags={"Driver Authentication"},
 *     summary="Make the driver register.",
 *     operationId="driverRegister",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                      "full_name", 
 *                      "email", 
 *                      "isd_code", 
 *                      "mobile", 
 *                      "password", 
 *                      "device_type",
 *                      "device_name",
 *                      "device_id",
 *                 },
 *                 @OA\Property(
 *                     property="profile_photo", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="full_name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                     format="email",
 *                 ),
 *                 @OA\Property(
 *                     property="isd_code", 
 *                     type="string",
 *                     example="+91"
 *                 ),
 *                 @OA\Property(
 *                     property="mobile", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="password", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_type", 
 *                     type="string", 
 *                     enum={"ios","android","web"},
 *                 ),
 *                 @OA\Property(
 *                     property="device_name", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_id", 
 *                     type="string"
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/LoginResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 */

class DriverRegister
{
    
}
