<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/update_license_image",
 *     tags={"Driver Authentication"},
 *     summary="submit driver license images.",
 *     operationId="driverLicense",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 @OA\Property(
 *                     property="license_front_image", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="license_back_image", 
 *                     type="string",
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="DriverLicenseResponse",
 *   type="string",
 * )
 */

class DriverLicense
{
}
