<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Delete(
 *     path="/user/delete_address/{id}",
 *     tags={"User Addresses"},
 *     summary="Delete the user address.",
 *     operationId="deleteUserAddress",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="id",
 *         description="id of a address that you want to delete.",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="integer",
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="DeleteUserAddressResponse",
 *   type="string",
 * )
 */

class DeleteUserAddress
{
}
