<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/user/delete_card",
 *     tags={"User Cards"},
 *     summary="Delete the user card.",
 *     operationId="deleteCard",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "id",
 *                      },
 *                 @OA\Property(
 *                     property="id", 
 *                     type="integer",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="DeleteCardResponse",
 *   type="string",
 * )
 */

class DeleteCard
{
}
