<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/delete_bank",
 *     tags={"Driver Bank Account"},
 *     summary="Delete the driver bank account.",
 *     operationId="deleteBank",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "id",
 *                      },
 *                 @OA\Property(
 *                     property="id", 
 *                     type="integer",
 *                     format="int64",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="DeleteBankResponse",
 *   type="string",
 * )
 */

class DeleteBank
{
}
