<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/content-pages/{slug}",
 *     tags={"Settings"},
 *     summary="Get the page content.",
 *     operationId="contentPage",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="slug",
 *         description="Slug of a page that you expect in response.",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="string",
 *              enum={"privacy-policy","tearms-conditions","about-us"},
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="ContentPageResponse",
 *   type="string",
 * )
 */

 class ContentPage { }