<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/ride_cancel",
 *     tags={"Booking Module"},
 *     summary="cancel user booking.",
 *     operationId="cancelRide",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"booking_id","cancel_reason_id","description","cancelled_by"},
 *                 @OA\Property(
 *                     property="booking_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="cancel_reason_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="description", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="cancelled_by", 
 *                     type="integer",
 *                     description="1=Customer, 2=Driver"
 *                 ),
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class CancelRide { }