<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/cancel_air_transport_booking",
 *     tags={"Air Transportation Module"},
 *     summary="Cancel the user air transportation booking.",
 *     operationId="cancelAirTransportBooking",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "reason_id","booking_id","reason"
 *                      },
 *                 @OA\Property(
 *                     property="reason_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="booking_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="reason", 
 *                     type="string",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="CancelAirTransportBookingResponse",
 *   type="string",
 * )
 */

class CancelAirTransportBooking
{
}
