<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/twilio/assign-mask-number",
 *     tags={"Call Masking"},
 *     summary="Assign Mask Number",
 *     operationId="callMasking",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"user_id"},
 *                 @OA\Property(property="user_id", type="string"),
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/CallMaskingResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 *
 * @OA\Schema(
 *   schema="CallMaskingResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Property(
 *         property="data",
 *         type="object",
 *         ref="#/components/schemas/AssignMaskResponseFields"
 *     )

 *   }
 * )
 * 
 * @OA\Schema(
 *     schema="AssignMaskResponseFields",
 *     type="object",
 *     @OA\Property(
 *         property="mask_number",
 *         type="string"
 *     ),
 * )

 */
class CallMasking
{
}
