<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/book_air_transport",
 *     tags={"Air Transportation Module"},
 *     summary="Book the user air transport trip.",
 *     operationId="bookAirTransportBooking",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "trip_type",
 *                        "pickup_location",
 *                        "dropoff_location",
 *                        "departure_date_time",
 *                        "flying_type",
 *                        "comment",
 *                        "adult",
 *                        "child",
 *                        "infants"
 *                      },
 *                 @OA\Property(
 *                     property="trip_type", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="pickup_location", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="dropoff_location", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="departure_date_time", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="arrival_date_time", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="flying_type", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="adult", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="child", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="infants", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="comment", 
 *                     type="string",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="BookAirTransportBookingResponse",
 *   type="string",
 * )
 */

class BookAirTransportBooking
{
}
