<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/book_a_taxi",
 *     tags={"Booking Module"},
 *     summary="Book the user taxi.",
 *     operationId="bookTaxi",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "pickup_location",
 *                        "dropoff_location",
 *                        "pickup_lat",
 *                        "pickup_long",
 *                        "dropoff_lat",
 *                        "dropoff_long",
 *                        "car_id",
 *                        "is_scheduled",
 *                        "payment_card_id",
 *                       
 *                      },
 *                 @OA\Property(
 *                     property="pickup_location", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="dropoff_location", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="pickup_lat", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="pickup_long", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="dropoff_lat", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="dropoff_long", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="car_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="is_scheduled", 
 *                     type="integer",
 *                     description="1 = scheduled, 0= not scheduled"
 *                 ),
 *                 @OA\Property(
 *                     property="schedule_date", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="schedule_time", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="user_price", 
 *                     type="number",
 *                 ),
 *                 @OA\Property(
 *                     property="payment_card_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="promocode_id", 
 *                     type="integer",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/BookATaxiResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="BookATaxiResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *               type="integer",
 *              
 *          )
 *      )
 *   }
 * )
 */

class BookATaxi
{
}
