<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/apply_promocode",
 *     tags={"Booking Module"},
 *     summary="apply promocode on booking.",
 *     operationId="applyPromocode",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"promocode"},
 *                 @OA\Property(
 *                     property="promocode", 
 *                     type="string",
 *                 ),
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/ApplyPromocodeResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * @OA\Schema(
 *   schema="ApplyPromocodeResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *               type="object",
 *              ref="#/components/schemas/PromocodeData"
 *              
 *          )
 *      )
 *   }
 * )
 */

 class ApplyPromocode { }
