<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/settings/app-version",
 *     tags={"Settings"},
 *     summary="Get the application version of each platform i.e. android, ios.",
 *     operationId="appVersion",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"platform", "version"},
 *                 @OA\Property(
 *                     property="platform", 
 *                     type="string",
 *                     description="platform of which you want version information. (ios & android)",
 *                     enum={"ios", "android"}
 *                 ),
 *                 @OA\Property(
 *                     property="version", 
 *                     type="string",
 *                     description="Application's current version. (ios & android)"
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/AppVersionResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * @OA\Schema(
 *   schema="AppVersionResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/AppVersion"
 *          )
 *      )
 *   }
 * )
 */

 class AppVersion { }