<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/user/add_address",
 *     tags={"User Addresses"},
 *     summary="Add the user address.",
 *     operationId="addUserAddress",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "apartment_name",
 *                        "street_address",
 *                        "city",
 *                        "postal_code",
 *                        "address_type",
 *                        "add_lat",
 *                        "add_long"
 *                      },
 *                 @OA\Property(
 *                     property="apartment_name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="street_address", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="city", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="postal_code", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="address_type", 
 *                     type="integer",
 *                     description="1=home,2=office,3=other",
 *                 ),
 *                 @OA\Property(
 *                     property="add_lat", 
 *                     type="number",
 *                 ),
 *                 @OA\Property(
 *                     property="add_long", 
 *                     type="number",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="AddUserAddressResponse",
 *   type="string",
 * )
 */

class AddUserAddress
{
}
