<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/user/add_card",
 *     tags={"User Cards"},
 *     summary="Add the user card.",
 *     operationId="addUserCard",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "card_token"
 *                      },
 *                 @OA\Property(
 *                     property="card_token", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="is_default", 
 *                     type="integer",
 *                     description="1=default,0=not default",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="AddCardResponse",
 *   type="string",
 * )
 */

class AddCard
{
}
