<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/add_bank_details",
 *     tags={"Driver Bank Account"},
 *     summary="Add the driver bank account.",
 *     operationId="addBank Account",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "acc_holder_name",
 *                        "routing_number",
 *                        "acc_number",
 *                        "acc_type",
 *                      },
 *                 @OA\Property(
 *                     property="acc_holder_name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="routing_number", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="acc_number", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="acc_type", 
 *                     type="string",
 *                     description="individual,company"
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="AddBankAccountResponse",
 *   type="string",
 * )
 */

class AddBankAccount
{
}
