<?php

use App\Http\Controllers\APIs\v1\AirTransportationBookingController;
use App\Http\Controllers\APIs\v1\BidController;
use App\Http\Controllers\APIs\v1\BookingController;
use App\Http\Controllers\APIs\v1\CarController;
use App\Http\Controllers\APIs\v1\CardController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\APIs\v1\LoginController;
use App\Http\Controllers\APIs\v1\SendOTPController;
use App\Http\Controllers\APIs\v1\SettingController;
use App\Http\Controllers\APIs\v1\RegisterController;
use App\Http\Controllers\APIs\v1\VerifyOTPController;
use App\Http\Controllers\APIs\v1\ContentPageController;
use App\Http\Controllers\APIs\v1\DriverController;
use App\Http\Controllers\APIs\v1\EarningController;
use App\Http\Controllers\APIs\v1\SocialLoginController;
use App\Http\Controllers\APIs\v1\UserProfileController;
use App\Http\Controllers\APIs\v1\UpdateLocaleController;
use App\Http\Controllers\APIs\v1\ResetPasswordController;
use App\Http\Controllers\APIs\v1\ForgotPasswordController;
use App\Http\Controllers\APIs\v1\UpdatePasswordController;
use App\Http\Controllers\APIs\v1\UserAddressController;
use App\Http\Controllers\APIs\v1\ReasonController;
use App\Http\Controllers\APIs\v1\HelpController;
use App\Http\Controllers\APIs\v1\FaqController;
use App\Http\Controllers\APIs\v1\ReviewController;
use App\Http\Controllers\APIs\v1\SubscriptionController;
use App\Http\Controllers\APIs\v1\TerminalController;
use App\Http\Controllers\APIs\v1\NotificationController;
use App\Http\Controllers\APIs\v1\TwilioController;
use App\Models\AirTransportationBooking;
use Illuminate\Support\Facades\Config;

Route::get('stripe_response', [SubscriptionController::class, 'response'])->name('stripeResponse');
Route::as('api.v1.')->prefix('v1')->group(function () {
    Route::post('/twilio/webhook/initiate-call', [TwilioController::class, 'initiateCall'])->name('twilio.initiate.call');
    Route::post('/twilio/webhook/handle-incoming-call', [TwilioController::class, 'handleIncomingCall'])->name('twilio.incoming.call');
    Route::post('/twilio/webhook/call-completion', [TwilioController::class, 'handleCallCompletion'])->name('twilio.complete.call');


    Route::get('/insert-dummy-records', [SettingController::class, 'insertDummyRecords']);
    Route::get('/insert-dummy-faq', [SettingController::class, 'insertDummyFaq']);
    Route::get('/insert-dummy-reason', [SettingController::class, 'insertDummyReason']);
    Route::get('/insert-dummy-help', [SettingController::class, 'insertDummyHelp']);
    Route::get('/insert-dummy-air', [SettingController::class, 'insertDummyAir']);
    Route::get('/insert-dummy-terminal', [SettingController::class, 'insertDummyTerminal']);
    Route::get('/insert-dummy-promocode', [SettingController::class, 'insertDummyPromocode']);

    Route::post('social-login', [SocialLoginController::class, 'socialLogin'])->name('social-login');

    Route::post('login', [LoginController::class, 'login'])->name('login');
    Route::post('register', [RegisterController::class, 'register'])->name('register');
    //driver register api
    Route::post('driver/register', [RegisterController::class, 'driverRegister'])->name('driver_register');
    Route::put('token/refresh', [LoginController::class, 'refresh'])->name('token.refresh')->middleware('refresh.sanctum');

    Route::post('password/email', [ForgotPasswordController::class, 'sendForgotPasswordLink'])->name('password.email');
    Route::post('password/reset', [ResetPasswordController::class, 'resetThePassword'])->name('password.update');

    Route::post('settings/app-version', [SettingController::class, 'getAppVersions'])->name('settings.app-version');

    Route::get('content-pages/{page_slug}', [ContentPageController::class, 'show'])->name('content-pages.show');
    // Route::get('user/get_addresses', [UserAddressController::class, 'get_list'])->name('user.addresses');

    Route::post('/addquote', [AirTransportationBookingController::class, 'addquote']);
    Route::post('/completeBooking', [AirTransportationBookingController::class, 'completeBooking']);
    Route::group(['middleware' => ['auth:sanctum', 'customer']], function () {
        Route::get('check_token', [HelpController::class, 'check'])->name('check_token');
        // Route::patch('send-otp', [SendOTPController::class, 'sendOTP'])->name('send-otp');
        // Route::patch('verify-otp', [VerifyOTPController::class, 'verifyOTP'])->name('verify-otp');

        Route::patch('update-password', [UpdatePasswordController::class, 'updatePassword'])->name('update-password');

        Route::patch('update-locale', [UpdateLocaleController::class, 'updateLocale'])->name('update-locale');

        Route::get('user/profile', [UserProfileController::class, 'show'])->name('user.profile');
        Route::post('user/update_profile', [UserProfileController::class, 'edit'])->name('user.update_profile');

        //user address api
        Route::get('user/get_addresses', [UserAddressController::class, 'get_list'])->name('user.addresses');
        Route::post('user/add_address', [UserAddressController::class, 'add_address'])->name('user.address.add');
        Route::put('user/update_address/{id}', [UserAddressController::class, 'update'])->name('user.address.update');
        Route::delete('user/delete_address/{id}', [UserAddressController::class, 'destroy'])->name('user.address.delete');
        Route::post('user/get_address_with_type', [UserAddressController::class, 'get_address_with_type'])->name('user.get_address_with_type');
        //review api
        Route::post('rate_driver', [ReviewController::class, 'giveDriverReview'])->name('rate_driver');
        Route::post('rate_airtransportation', [ReviewController::class, 'giveAirtransportationReview'])->name('rate_airtransportation');
        //card management api
        Route::post('user/add_card', [CardController::class, 'addCard'])->name('add.card');
        Route::get('user/get_cards', [CardController::class, 'getCardList'])->name('user.cards');
        Route::post('user/delete_card', [CardController::class, 'deleteCard'])->name('delete.card');
        Route::post('user/make_card_default', [CardController::class, 'makeDefault'])->name('default.card');

        //air transportation apis
        Route::get('get_terminals', [TerminalController::class, 'getTerminals'])->name('get_terminals');
        Route::post('book_air_transport', [AirTransportationBookingController::class, 'bookAirTransport'])->name('book.air_transport');
        Route::post('cancel_air_transport_booking', [AirTransportationBookingController::class, 'cancelAirTransportBooking'])->name('cancel.air_transport');
        Route::get('get_quotes/{offset}/{page}', [AirTransportationBookingController::class, 'getQuotes'])->name('get_quotes');
        Route::post('get_quote_details', [AirTransportationBookingController::class, 'getQuotesDetails'])->name('get_quotes_details');
        Route::post('update_quote_status', [AirTransportationBookingController::class, 'updateQuoteStatus'])->name('update_quote_status');
        Route::post('get_air_tranport_bookings', [AirTransportationBookingController::class, 'getBookings'])->name('get_air_tranport_bookings');
        Route::post('get_air_booking_details', [AirTransportationBookingController::class, 'getBookingDetails'])->name('get_air_booking_details');
        Route::get('/flying-types', function () {
            return response()->json(['flying_types' => config('constant.flying_types')]);
        });
        //update social user details
        // Route::post('update_social_user', [RegisterController::class, 'updateSocialUser'])->name('update_social_user');
        //bookings api
        Route::post('book_a_taxi', [BookingController::class, 'rideBooking'])->name('book_a_taxi');
        Route::post('apply_promocode', [BookingController::class, 'applyPromocode'])->name('apply_promocode');
        Route::post('remove_promocode', [BookingController::class, 'removePromocode'])->name('remove_promocode');
        Route::post('get_bookings', [BookingController::class, 'getBookings'])->name('get_bookings');

        //bids api
        Route::get('get_received_bids', [BidController::class, 'getBids'])->name('get_received_bids');
        Route::post('update_bid_status', [BidController::class, 'updateBidStatus'])->name('update_bid_status');
        //get nearby drivers
        Route::post('get_nearby_drivers', [DriverController::class, 'getNearbyDrivers'])->name('get_nearby_drivers');
        //check for searching
        Route::get('driver_searching', [BookingController::class, 'checkBookingForBids'])->name('driver_searching');
        Route::delete('/delete-account', [UserProfileController::class, 'deleteAccount'])->name('delete-account');
    });

    Route::prefix('driver')->middleware('auth:sanctum', 'driver')->group(function () {
        //driver license image api
        Route::post('update_license_image', [DriverController::class, 'updateDriverLicense'])->name('license_image');
        Route::post('update_vehicle_info', [DriverController::class, 'updateVehicleInfo'])->name('vehicle_info');
        Route::post('update_vehicle_images', [DriverController::class, 'updateVehicleImages'])->name('vehicle_images');
        Route::post('add_bank_details', [DriverController::class, 'addBankAccount'])->name('driver.add_bank_details');
        Route::get('get_banks', [DriverController::class, 'getBankList'])->name('driver.banks');
        Route::post('delete_bank', [DriverController::class, 'deleteBank'])->name('delete.bank');
        Route::post('make_bank_default', [DriverController::class, 'makeDefault'])->name('default.bank');
        Route::post('update_online_status', [DriverController::class, 'updateOnlineStatus'])->name('online_status');
        Route::patch('update-password', [UpdatePasswordController::class, 'updatePassword'])->name('driver-update-password');
        Route::get('profile', [DriverController::class, 'getProfile'])->name('driver.profile');
        Route::post('update_profile', [DriverController::class, 'updateProfile'])->name('driver.update_profile');
        Route::get('get_license_image', [DriverController::class, 'getDriverID'])->name('driver.driver_id');
        Route::get('get_vehicle_image', [DriverController::class, 'getVehicleImages'])->name('driver.vehicleimage');
        Route::get('get_vehicle_info', [DriverController::class, 'getVehicleInfo'])->name('driver.vehicleinfo');
        Route::get('get_bank_info', [DriverController::class, 'getBankList'])->name('driver.bankinfo');
        Route::get('get_plans', [SubscriptionController::class, 'getPlans'])->name('get_plans');
        Route::post('subscribe', [SubscriptionController::class, 'driverSubscription'])->name('subscribe');

        Route::post('update_current_ride_status', [BookingController::class, 'updateCurrentRideStatus'])->name('driver.update_current_ride_status');
        Route::post('update_location', [DriverController::class, 'updateLocation'])->name('update_location');
        Route::post('get_earning_graph_data', [EarningController::class, 'getEarningHistory'])->name('get_earning_data');
        Route::delete('delete_my_account', [DriverController::class, 'deleteMyAccount'])->name('delete_my_account');
        Route::get('get_status', [DriverController::class, 'getStatus'])->name('get_status');
        Route::get('get_customer_request', [BookingController::class, 'getCustomerRequest'])->name('get_customer_request');
        Route::post('get_bookings', [BookingController::class, 'getDriverBookings'])->name('get_driver_bookings');
        Route::post('get_earning_list_data', [EarningController::class, 'getEarningHistoryList'])->name('get_earning_list_data');
        Route::post('export_earning_data', [EarningController::class, 'ExportEarningData'])->name('export_earning_data');
        Route::post('get_home_details', [DriverController::class, 'getHomeDetails'])->name('get_home_details');
        Route::delete('/delete-account', [DriverController::class, 'deleteAccount'])->name('driver-delete-account');
    });

    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::patch('send-otp', [SendOTPController::class, 'sendOTP'])->name('send-otp');
        Route::patch('verify-otp', [VerifyOTPController::class, 'verifyOTP'])->name('verify-otp');
        //get car type api
        Route::get('get_car_types', [CarController::class, 'get_list'])->name('car_types');
        //cancel reasons api
        Route::get('get_cancel_reason/{type}', [ReasonController::class, 'get_list'])->name('cancel.reason');
        //help reason api
        Route::get('get_help_topics/{type}', [HelpController::class, 'get_list'])->name('help.topics');
        Route::post('send_help_request', [HelpController::class, 'send_request'])->name('help.request');
        //get faq api
        Route::get('get_faqs/{type}', [FaqController::class, 'get_list'])->name('faqs');
        Route::controller(LoginController::class)->group(function () {
            Route::delete('logout', 'logout')->name('logout');
            Route::delete('past/logout', 'logoutFromPastLogin')->name('past-logout');
        });
        //bids api
        Route::post('update_bid_status', [BidController::class, 'updateBidStatus'])->name('update_bid_status');
        Route::post('update_location', [BookingController::class, 'updateLocation'])->name('update_location');
        //cancel ride
        Route::post('ride_cancel', [BookingController::class, 'rideCancel'])->name('cancel_a_ride');
        Route::get('get_current_booking_details', [BookingController::class, 'getCurrentBookingDetails'])->name('get_current_booking_details');
        Route::post('get_booking_details', [BookingController::class, 'getBookingDetails'])->name('get_booking_details');
        //get notification api
        Route::get('get_notification_list', [NotificationController::class, 'getNotification'])->name('get_notification_list');
        Route::post('/twilio/assign-mask-number', [TwilioController::class, 'assignMaskNumber']);
    });
});
