<?php

use App\Http\Controllers\Admin\AdminController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\Auth\ResetPasswordController;
use App\Http\Controllers\Admin\Auth\ForgotPasswordController;
use App\Http\Controllers\Admin\ContentPageController;
use App\Http\Controllers\Admin\EmailController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SeederController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\DriverController;
use App\Http\Controllers\Admin\AirTransportationController;
use App\Http\Controllers\Admin\CarController;
use App\Http\Controllers\Admin\PromocodeController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\EarningController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\BookingController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\HelpController;
use App\Http\Controllers\Admin\ReasonController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\SubAdminController;
use App\Http\Controllers\AirTransport\AdminController as AirTransportAdminController;
use App\Http\Controllers\AirTransport\Auth\ForgotPasswordController as AuthForgotPasswordController;
use App\Http\Controllers\AirTransport\Auth\ResetPasswordController as AuthResetPasswordController;
use App\Http\Controllers\AirTransport\Auth\LoginController as AuthLoginController;
use App\Http\Controllers\AirTransport\Auth\OtpController;
use App\Http\Controllers\AirTransport\Auth\RegisterController;
use App\Http\Controllers\AirTransport\BookingController as AirTransportBookingController;
use App\Http\Controllers\AirTransport\ChatController;
use App\Http\Controllers\AirTransport\HomeController as AirTransportHomeController;
use App\Http\Controllers\AirTransport\JetController;
use App\Http\Controllers\AirTransport\PilotController;
use App\Http\Controllers\AirTransport\TerminalController;
use App\Http\Controllers\AirTransport\ReviewController as AirTransportReviewController;
use App\Http\Controllers\AirTransport\SubscriptionController as AirTransportSubscriptionController;
use App\Http\Controllers\AirTransport\TimeslotController;
use App\Http\Controllers\AirTransport\NotificationController as AirTransportNotificationController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\StateController;
use Inertia\Inertia;

Route::group(['prefix'=> 'admin', 'as'=> 'admin.', 'middleware'=> 'admin'], function() {
    // Route::get(
    //     '/',
    //     function () {
    //         return Inertia::render(
    //             'Home',
    //             [
    //                 'title' => 'Homepage',
    //             ]
    //         );
    //     }
    // )->name( 'homepage' );

    Route::get('login', [LoginController::class, 'showLoginForm']);
    Route::post('login', [LoginController::class, 'login'])->name('login');

    Route::post('logout', [LoginController::class, 'logout'])->name('logout');

    Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
    Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::get('password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
    Route::post('password/reset', [ResetPasswordController::class, 'reset'])->name('password.update');
    Route::post('update-status/{id}', [DriverController::class, 'updateStatus'])->name('driver.status.update');    
    Route::group(['middleware'=> 'auth:admin'], function() {

       
        
        Route::get('set-locale/{locale}', [AdminController::class, 'setLocale'])->name('set-locale');
        Route::get('my-account/password/reset-form', [AdminController::class, 'showUpdatePasswordForm'])->name('my-account.password.reset');
        Route::post('my-account/password/reset', [AdminController::class, 'updatePassword'])->name('my-account.password.update');

        Route::group(['middleware' => ['permission:Dashboard']], function () {
            Route::get('/', [HomeController::class, 'index'])->name('home');
            Route::post('/', [HomeController::class, 'index'])->name('home');
        });
        
        Route::group(['middleware' => ['permission:Content Pages List|Content Pages Update|Roles Delete|Content Pages Add']], function () {
            Route::resource('content-pages', ContentPageController::class);
            Route::patch('content-pages/{content_page}/active', [ContentPageController::class, 'active'])->name('content-pages.active');
        });

        
         Route::group(['middleware' => ['permission:Roles List|Roles Update|Roles Delete|Roles Add']], function () {
            Route::patch('roles/{role}/active', [RoleController::class, 'active'])->name('roles.active');
            Route::resource('roles', RoleController::class);
         });

        Route::group(['middleware' => ['permission:Permission List|Permission Update|Permission Delete|Permission Add']], function () {
            Route::get('permissions/list', [PermissionController::class, 'permissionsList'])->name('permissions.list');
            Route::resource('permissions', PermissionController::class);
        });

         Route::group(['middleware' => ['permission:Sub Admins List|Sub Admins Update|Sub Admins Delete|Sub Admins Add']], function () {
            Route::resource('sub-admins', SubAdminController::class);
            Route::patch('sub-admins/{sub_admin}/active', [SubAdminController::class, 'active'])->name('sub-admins.active');
        });

        Route::group(['middleware' => ['permission:User List|User View|User Update']], function () {
            Route::resource('users', UserController::class);
            Route::patch('users/{user}/active', [UserController::class, 'active'])->name('users.active');

        });
        
        Route::group(['middleware' => ['permission:Driver List|Driver View|Driver Update']], function () {
            Route::resource('drivers', DriverController::class);
            Route::patch('drivers/{driver}/occupy', [DriverController::class, 'occupy'])->name('drivers.occupy');
            Route::patch('drivers/{driver}/active', [DriverController::class, 'active'])->name('drivers.active');
        });

        Route::group(['middleware' => ['permission:Air Transportation List|Air Transportation View|Air Transportation Delete|Air Transportation Update']], function () {
            Route::resource('air-transportation', AirTransportationController::class);
            Route::patch('air-transportation/{air_transportation}/active', [AirTransportationController::class, 'active'])->name('air-transportation.active');
            Route::post('air-transportations/{air_transportation}/update-status', [AirTransportationController::class, 'updateStatus'])->name('air-transportation.update-status');
        });
        
        Route::group(['middleware' => ['permission:Car List|Car Update|Car Delete|Car Add']], function () {
            Route::resource('cars', CarController::class);
            Route::patch('cars/{car}/active', [CarController::class, 'active'])->name('cars.active');
        });
        
        Route::group(['middleware' => ['permission:Faq List|Faq Update|Faq Delete|Faq Add']], function () {
            Route::resource('faqs', FaqController::class);
            Route::patch('faqs/{faq}/active', [FaqController::class, 'active'])->name('faqs.active');
        });

        Route::group(['middleware' => ['permission:Help Reason List|Help Reason Update|Help Reason Delete|Help Reason Add']], function () {
            Route::resource('help', HelpController::class);
            Route::patch('help/{help_reason}/active', [HelpController::class, 'active'])->name('help.active');
        });
        
        Route::group(['middleware' => ['permission:Cancel Reason List|Cancel Reason Update|Cancel Reason Delete|Cancel Reason Add']], function () {
            Route::resource('reason', ReasonController::class);
            Route::patch('reason/{cancel_reason}/active', [ReasonController::class, 'active'])->name('reason.active');
        });
       
        Route::group(['middleware' => ['permission:Push Notifications List|Push Notifications Add']], function () {
            Route::resource('notification', NotificationController::class);

        });

        Route::group(['middleware' => ['permission:Earning View']], function () {
            Route::get('earnings', [EarningController::class, 'index'])->name('earnings');
            Route::post('earnings', [EarningController::class, 'index'])->name('earnings.index');
        });

        Route::group(['middleware' => ['permission:Review Delete|Review List']], function () {
            Route::get('reviews', [ReviewController::class, 'index'])->name('reviews');
            Route::delete('destroy/{id}', [ReviewController::class, 'destroy'])->name('reviews.destroy');
        });

        Route::group(['middleware' => ['permission:Bookings List|Bookings View|Bookings Update']], function () {
            Route::resource('bookings', BookingController::class);
            Route::get('get_bookings', [BookingController::class, 'bookings'])->name('get_bookings');
            Route::get('get_air_bookings', [BookingController::class, 'airBooking'])->name('get_air_bookings');
            Route::get('airbookings/{id}', [BookingController::class, 'showairbooking'])->name('airbookings.show');
            Route::post('get_drivers', [BookingController::class, 'getDrivers'])->name('get_drivers');
            Route::post('assign_driver', [BookingController::class, 'assignDriver'])->name('assign_driver');

        });

        Route::resource('subscription', SubscriptionController::class);
       
        Route::group(['middleware' => ['permission:Settings Update|Settings List']], function () {
            Route::get('settings', [SettingController::class, 'index'])->name('settings');
            Route::patch('settings/waiting/update', [SettingController::class, 'updateWaiting'])->name('update-waiting');
            Route::patch('settings/radius/update', [SettingController::class, 'updateRadius'])->name('update-radius');
            Route::patch('settings/cancel/update', [SettingController::class, 'updateCancellation'])->name('update-cancel');
        });
       
        Route::group(['middleware' => ['permission:PromoCodes List|PromoCodes Add|PromoCodes Delete']], function () {
            Route::resource('promocodes', PromocodeController::class);
            Route::patch('promocodes/{promocode}/active', [PromocodeController::class, 'active'])->name('promocodes.active');
        });

        Route::group(['middleware' => ['permission:Earning View']], function () {
            Route::get('get_earnings_list', [EarningController::class, 'getList'])->name('get_earnings_list');
            Route::get('get_admin_earnings_list', [EarningController::class, 'getAdminList'])->name('get_admin_earnings_list');
        });
        
       
        Route::get('run-seeder', [SettingController::class, 'runSeeder'])->name('runSeeder');
        
        Route::group(['middleware' => ['role:developer']], function () {

            Route::get('settings/mobile/show', [SettingController::class, 'mobileDetails'])->name('settings.mobile.show');
            Route::patch('settings/mobile/update', [SettingController::class, 'updateMobileSettings'])->name('settings.mobile');

            Route::get('settings/email/show', [EmailController::class, 'show'])->name('settings.email.show');
            Route::put('settings/email/update', [EmailController::class, 'update'])->name('settings.email.update');

            Route::resource('countries', CountryController::class)->only('index');
            Route::patch('countries/{activate}/bulk-active', [CountryController::class, 'builkActive'])->name('countries.bulk-active');
            Route::patch('countries/{country}/active', [CountryController::class, 'active'])->name('countries.active');
            
            Route::resource('states', StateController::class)->only('index');
            Route::patch('states/{activate}/bulk-active', [StateController::class, 'builkActive'])->name('states.bulk-active');
            Route::patch('states/{state}/active', [StateController::class, 'active'])->name('states.active');
            
            Route::resource('cities', CityController::class)->only('index');
            Route::patch('cities/{activate}/bulk-active', [CityController::class, 'builkActive'])->name('cities.bulk-active');
            Route::patch('cities/{city}/active', [CityController::class, 'active'])->name('cities.active');
            
            Route::get('seeders', [SeederController::class, 'index'])->name('settings.seeders.index');
            Route::post('seeders/execute', [SeederController::class, 'execute'])->name('settings.seeders.execute');
        });
    });
});

Route::group(['prefix'=> 'airtransport', 'as'=> 'airtransport.', 'middleware'=> 'airtransport'], function() {
    
    Route::get('login', [AuthLoginController::class, 'showLoginForm'])->name('login');
    Route::get('password/reset', [AuthForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
    Route::post('password/email', [AuthForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::get('password/reset/{token}', [AuthResetPasswordController::class, 'showResetForm'])->name('password.reset');
    Route::post('password/reset', [AuthResetPasswordController::class, 'reset'])->name('password.update');
    Route::post('login', [AuthLoginController::class, 'login'])->name('login');
    Route::get('signup', [RegisterController::class, 'showRegistrationForm'])->name('signup');
    
    Route::post('signup', [RegisterController::class, 'register'])->name('register');
    Route::post('logout', [AuthLoginController::class, 'logout'])->name('logout');
    
    Route::group(['middleware'=> 'auth:airtransport'], function() {

        Route::get('/', [AirTransportHomeController::class, 'index'])->name('home');
        Route::post('submit-quote', [AirTransportHomeController::class, 'submitQuote'])->name('submit-quote');
        Route::post('change-booking-status', [AirTransportBookingController::class, 'changeStatus'])->name('change-booking-status');
        Route::post('change-status', [AirTransportHomeController::class, 'changeStatus'])->name('change-status');
        Route::resource('terminals', TerminalController::class);
        Route::post('terminals/delete-image', [TerminalController::class, 'deleteImage'])->name('terminals.delete-image');
        Route::resource('jets', JetController::class);
        Route::patch('jets/{jet}/active', [JetController::class, 'active'])->name('jets.active');
        Route::post('jets/delete-image', [JetController::class, 'deleteImage'])->name('jets.delete-image');
        Route::resource('pilots', PilotController::class);
        Route::patch('pilots/{pilot}/active', [PilotController::class, 'active'])->name('pilots.active');
        Route::patch('terminals/{terminal}/active', [TerminalController::class, 'active'])->name('terminals.active');
        Route::get('my-account/password/reset-form', [AirTransportAdminController::class, 'showUpdatePasswordForm'])->name('profile.password.reset');
        Route::post('my-account/password/reset', [AirTransportAdminController::class, 'updatePassword'])->name('profile.password.update');
        Route::get('bookings', [AirTransportBookingController::class, 'getBookings'])->name('bookings');
        Route::post('cancel-trip', [AirTransportBookingController::class, 'cancelTrip'])->name('cancel-trip');
        Route::get('reviews', [AirTransportReviewController::class, 'index'])->name('reviews.index');
        Route::get('reviews/{id}', [AirTransportReviewController::class, 'show'])->name('reviews.show');
        Route::post('add-step2', [AirTransportAdminController::class, 'addJets'])->name('add-step2');
        Route::post('add-step3', [AirTransportAdminController::class, 'addPilotTerminals'])->name('add-step3');
        Route::post('add-step4', [AirTransportAdminController::class, 'addCompanyDetails'])->name('add-step4');
        Route::get('signup-step', [AirTransportAdminController::class, 'showRegistrationForm'])->name('signup.step');
        Route::post('resend-otp', [OtpController::class, 'resendOTP'])->name('resend-otp');
        Route::get('otp', [OtpController::class, 'showOTPForm'])->name('otp');
        Route::post('verify-otp',[OtpController::class, 'verifyOtp'])->name('verify-otp');
        Route::get('buy-subscription',[AirTransportSubscriptionController::class, 'index'])->name('buy-subscription');
        Route::get('account-setting', [AirTransportAdminController::class, 'showAccountSettingForm'])->name('account-setting');
        Route::post('update-profile', [AirTransportAdminController::class, 'updateProfile'])->name('update-profile');
        Route::post('help', [AirTransportAdminController::class, 'submitHelp'])->name('help');
        Route::get('add-card',[AirTransportSubscriptionController::class, 'addCard'])->name('add-card');
        Route::post('subscribe-airtransport',[AirTransportSubscriptionController::class, 'buySubscription'])->name('subscribe-airtransport');
        Route::get('chats',[ChatController::class, 'index'])->name('chats.index');
        Route::post('get-chat',[ChatController::class, 'getChat'])->name('get-chat');
        Route::get('timeslots', [TimeslotController::class, 'index'])->name('timeslots.index');
        Route::post('add-timeslot', [TimeslotController::class, 'addUpdateTimeslot'])->name('add-timeslot');
        Route::post('add-override-timeslot', [TimeslotController::class, 'addOverrideTimeslot'])->name('add-override-timeslot');
        Route::delete('delete-override-timeslot', [TimeslotController::class, 'deleteOverrideTimeslot'])->name('delete-override-timeslot');
        Route::post('delete-account', [AirTransportAdminController::class, 'deleteAccount'])->name('delete-account');
        Route::get('manage-subscription',[AirTransportSubscriptionController::class, 'getSubscription'])->name('manage-subscription');
        Route::get('notification-list',[AirTransportNotificationController::class, 'index'])->name('notification-list');

        Route::get('add-token/{token}', [AirTransportAdminController::class, 'addFcmToken'])->name('add-token');

    });
}); 