const path = require("path");
const mix = require('laravel-mix');
var webpack = require('webpack');
const directory = process.env.DIR_PATH
const awsUrl = process.env.AWS_URL;
const pkKey = process.env.STRIPE_PUBLISHABLE_KEY
const accID =process.env.STRIPE_ACCOUNT
const SENDBIRD_APP_ID =process.env.SENDBIRD_APP_ID
// Rezolve Ziggy
mix.alias({
  ziggy: path.resolve("vendor/tightenco/ziggy/dist/vue"),
});

mix.js('resources/js/app.js', 'public/js')
    .vue()
    .webpackConfig({
      resolve: {
          alias: {
              "@": path.resolve("resources/js"),
          },
      },
      output: {
        publicPath: directory,
    },
    plugins: [
      new webpack.DefinePlugin({
         'process.env': {
            AWS_URL: JSON.stringify(awsUrl),
            STRIPE_PUBLISHABLE_KEY: JSON.stringify(pkKey),
            STRIPE_ACCOUNT:  JSON.stringify(accID),
            SENDBIRD_APP_ID:  JSON.stringify(SENDBIRD_APP_ID)
         },
      }),
   ]
  })
    .postCss('resources/css/app.css', 'public/css', [
        require("tailwindcss"),
      ])
    .setResourceRoot(directory)
    .sourceMaps();
// mix.js('resources/js/app.js', 'public/js')
//     .vue()
//     .postCss('resources/css/app.css', 'public/css', [
//         //
//     ]);
// mix.js("resources/js/app.js", "public/js")
//   .postCss("resources/css/app.css", "public/css", [
//     require("tailwindcss"),
//   ]);