<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="javascript:;" class="brand-link">
        <img src="{{ asset('admin_assets/images/AdminLTELogo.png') }}" 
            alt="{{ config('app.name') }} Logo" 
            class="brand-image img-circle elevation-3"
            style="opacity: .8">
        <span class="brand-text font-weight-light">{{ config('app.name') }}</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex align-items-center">
            <div class="image">
                <img src="{{ asset('admin_assets/images/user2-160x160.jpg') }}" 
                    class="img-circle elevation-2" 
                    alt="User Image">
            </div>
            <div class="info" style="white-space: initial">
                <a href="javascript:;" class="d-block">{{ config('app.name') }} {{ __('basecode/admin.label.admin_panel') }}</a>
            </div>
        </div>

        <!-- SidebarSearch Form -->
        <div class="form-inline">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="{{ __('basecode/admin.label.search') }}" aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class with font-awesome or any other icon font library -->
                <li class="nav-item">
                    <a href="{{ route('admin.home') }}" @class(['nav-link', 'active'=> request()->routeIs('admin.home')])">
                        <i class="fa-solid fa-gauge-high"></i>
                        <p>{{ __('basecode/admin.menus.dashboard') }}</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.users.index') }}" @class(['nav-link', 'active'=> request()->routeIs('admin.users.*')])">
                        <i class="fa-solid fa-users"></i>
                        <p>{{ __('basecode/admin.menus.users') }}</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.content-pages.index') }}" @class(['nav-link', 'active'=> request()->routeIs('admin.content-pages.*')])">
                        <i class="fa-solid fa-file-circle-plus"></i>
                        <p>{{ __('basecode/admin.menus.content_pages') }}</p>
                    </a>
                </li>
                <li class="nav-header">Settings</li>
                <li @class([
                    'nav-item', 
                    'menu-open'=> request()->routeIs('admin.my-account.password.reset')
                ])>
                    <a href="#" @class([
                        'nav-link', 
                        'active'=> request()->routeIs('admin.my-account.password.reset')
                    ])>
                        <i class="fa-solid fa-id-card-clip"></i>
                        <p>
                            {{ __('basecode/admin.menus.my_profile') }}
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.my-account.password.reset') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.my-account.password.reset')
                            ])>
                                <i class="fa-solid fa-user-lock"></i>
                                <p>{{ __('basecode/admin.menus.update_password') }}</p>
                            </a>
                        </li>
                    </ul>
                </li>

                @role('developer')
                <li @class([
                    'nav-item', 
                    'menu-open'=> request()->routeIs('admin.settings.*')
                ])>
                    <a href="#" @class([
                        'nav-link', 
                        'active'=> request()->routeIs('admin.settings.*')
                    ])>
                        <i class="fa-solid fa-gears"></i>
                        <p>
                            {{ __('basecode/admin.menus.app_settings') }}
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.settings.mobile.show') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.settings.mobile.show')
                            ])>
                                <i class="fa-solid fa-mobile-screen-button"></i>
                                <p>{{ __('basecode/admin.menus.mobile_management') }}</p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.settings.email.show') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.settings.email.show')
                            ])>
                                <i class="fa-solid fa-envelope"></i>
                                <p>{{ __('basecode/admin.menus.email_configuration') }}</p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.settings.seeders.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.settings.seeders.index')
                            ])>
                                <i class="fa-solid fa-database"></i>
                                <p>{{ __('basecode/admin.menus.seeders_management') }}</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li @class([
                    'nav-item', 
                    'menu-open'=> request()->routeIs('admin.countries.*', 'admin.states.*', 'admin.cities.*')
                ])>
                    <a href="#" @class([
                        'nav-link', 
                        'active'=> request()->routeIs('admin.countries.*', 'admin.states.*', 'admin.cities.*')
                    ])>
                        <i class="fa-solid fa-earth-asia"></i>
                        <p>
                            {{ __('basecode/admin.menus.world') }}
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.countries.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.countries.*')
                            ])>
                                <i class="fa-solid fa-flag"></i>
                                <p>{{ __('basecode/admin.menus.countries') }}</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.states.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.states.*')
                            ])>
                                <i class="fa-solid fa-location-arrow"></i>
                                <p>{{ __('basecode/admin.menus.states') }}</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.cities.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.cities.*')
                            ])>
                                <i class="fa-solid fa-city"></i>
                                <p>{{ __('basecode/admin.menus.cities') }}</p>
                            </a>
                        </li>
                    </ul>
                </li>
                @endrole
                
                <li @class([
                    'nav-item', 
                    'menu-open'=> request()->routeIs('admin.sub-admins.*')
                                || request()->routeIs('admin.roles.*')
                                || request()->routeIs('admin.permissions.*')
                ])>
                    <a href="#" @class([
                        'nav-link', 
                        'active'=> request()->routeIs('admin.sub-admins.*')
                    ])>
                        <i class="fa-solid fa-users-gear"></i>
                        <p>
                            {{ __('basecode/admin.menus.sub_admin_management') }}
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.sub-admins.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.sub-admins.*')
                            ])>
                                <i class="fa-solid fa-users-between-lines"></i>
                                <p>{{ __('basecode/admin.menus.sub_admins') }}</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.roles.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.roles.*')
                            ])>
                                <i class="fa-solid fa-user-tag"></i>
                                <p>{{ __('basecode/admin.menus.roles') }}</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.permissions.index') }}" 
                            @class([
                                'nav-link',
                                'active'=> request()->routeIs('admin.permissions.*')
                            ])>
                                <i class="fa-solid fa-shield-halved"></i>
                                <p>{{ __('basecode/admin.menus.permissions') }}</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="javascript:void(0);" class="nav-link" onclick="event.preventDefault(); document.getElementById('js-logout-form').submit();">
                        <i class="nav-icon fas fa-reply"></i>
                        <p>{{ __('basecode/admin.menus.logout') }}</p>
                    </a>
                    <form id="js-logout-form" action="{{ route('admin.logout') }}" method="POST" style="display: none;">
                        @csrf
                    </form>
                </li>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>