@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.user_detail');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> __('basecode/admin.menus.users'), 'target'=> route('admin.users.index')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>

    <section class="content">
        <div class="container-fluid">

            <div class="row justify-content-center">
                <div class="col-md-4">
                    <!-- Widget: user widget style 1 -->
                    <div class="card card-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <div @class(['widget-user-header', 'bg-success'=> $user->is_active, 'bg-danger'=> !$user->is_active])">
                            <h3 class="widget-user-username">{{ $user->name }}</h3>
                            <h5 class="widget-user-desc">{{ $user->email }}</h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle elevation-2" src="{{ asset('admin_assets/images/user2-160x160.jpg') }}" alt="User Avatar">
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-sm-4 border-right">
                                    <div class="description-block">
                                        <h5 class="description-header">
                                            <span @class([
                                                'badge',
                                                'bg-success'=> $user->email_verified_at,
                                                'bg-danger'=> !$user->email_verified_at
                                            ])>
                                                <i @class([
                                                    'fa solid',
                                                    'fa-check'=> $user->email_verified_at,
                                                    'fa-xmark'=> !$user->email_verified_at
                                                ])></i>
                                            </span>
                                        </h5>
                                        <span class="description-text">{{ __('basecode/admin.users.email_verified') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-4 border-right">
                                    <div class="description-block">
                                        <h5 class="description-header">
                                            <span @class([
                                                'badge',
                                                'bg-success'=> $user->mobile_verified_at,
                                                'bg-danger'=> !$user->mobile_verified_at
                                            ])>
                                                <i @class([
                                                    'fa solid',
                                                    'fa-check'=> $user->mobile_verified_at,
                                                    'fa-xmark'=> !$user->mobile_verified_at
                                                ])></i>
                                            </span>
                                        </h5>
                                        <span class="description-text">{{ __('basecode/admin.users.mobile_verified') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-4">
                                    <div class="description-block">
                                        <h5 class="description-header">{{ $user->created_at->format('F d, Y') }}</h5>
                                        <span class="description-text">{{ __('basecode/admin.users.registered_on') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                    </div>
                    <!-- /.widget-user -->
                </div>
            </div>
            <div class="row mt-5 justify-content-center">
                <div class="col-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('basecode/admin.users.login_details') }}</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body p-0">
                            <table class="table table-sm">
                                <thead>
                                    <tr align="center" valign="center">
                                        <th style="width: 10px">#</th>
                                        <th>{{ __('basecode/admin.users.device_type') }}</th>
                                        <th>{{ __('basecode/admin.users.device_name') }}</th>
                                        <th>{{ __('basecode/admin.users.last_used_at') }}</th>
                                        <th>{{ __('basecode/admin.users.expired_at') }}</th>
                                        <th>{{ __('basecode/admin.users.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($tokens as $index=> $token)
                                    <tr align="center" valign="center">
                                        <td>{{ $index+1 }}</td>
                                        <td>
                                            @if ($token->device_type == 1)
                                                <i class="fa-brands fa-apple"></i>
                                            @elseif($token->device_type == 2)
                                                <i class="fa-brands fa-android"></i>
                                            @else
                                                <i class="fa-solid fa-earth-africa"></i>
                                            @endif
                                        </td>
                                        <td>{{ $token->device_name }}</td>
                                        <td>{{ $token->last_used_at?->diffForHumans() ?? '-' }}</td>
                                        <td>{{ $token->expired_at?->diffForHumans() ?? '-' }}</td>
                                        <td>
                                            @if (
                                                !$token->expired_at?->isPast() 
                                                || (!$token->expired_at?->isPast() && !$token->last_used_at)
                                            )
                                            <span class="badge bg-success">Active</span>
                                            @elseif (!$token->expired_at?->isPast() && !$token->last_used_at)
                                                <span class="badge bg-secondary">{{ __('basecode/admin.users.issued') }}</span>
                                            @elseif($token->expired_at?->isPast())
                                                <span class="badge bg-warning">{{ __('basecode/admin.users.expired_at') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="6" class="text-center">
                                            {{ 
                                                __('basecode/admin.messages.not_found', [
                                                    'thing'=> __('basecode/admin.users.login_details')
                                                ]) 
                                            }}
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <div class="row mt-5 justify-content-center">
                <div class="col-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('basecode/admin.users.personal_details') }}</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body p-0">
                            <table class="table table-sm">
                                <tbody>
                                    <tr>
                                        <th>{{ __('basecode/admin.label.locale') }}</th>
                                        <td>{{ $user->locale }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ __('basecode/admin.label.isd_code') }}</th>
                                        <td>{{ $user->isd_code ?: '-' }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ __('basecode/admin.label.mobile') }}</th>
                                        <td>{{ $user->mobile ?: '-' }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ __('basecode/admin.users.email_verified_at') }}</th>
                                        <td>{{ $user->email_verified_at?->format('F d, Y') ?: '-' }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ __('basecode/admin.users.mobile_verified_at') }}</th>
                                        <td>{{ $user->mobile_verified_at?->format('F d, Y') ?: '-' }}</td>
                                    </tr>

                                    {{-- @foreach ($loginTypes as $loginType)
                                        <tr>
                                            <th>{{ __('basecode/admin.users.'.$loginType->login_type.'_at') }}</th>
                                            <td>{{ $loginType->updated_at }}</td>
                                        </tr>
                                    @endforeach --}}
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>
</script>
@endpush