@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.user_detail');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> __('basecode/admin.menus.users'), 'target'=> route('admin.users.index')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>

    <section class="content">
        <div class="container-fluid">

            <div class="row justify-content-center">
                <div class="col-md-4">
                    <!-- Widget: user widget style 1 -->
                    <div class="card card-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <div @class(['widget-user-header', 'bg-success'=> $admin->is_active, 'bg-danger'=> !$admin->is_active])">
                            <h3 class="widget-user-username">{{ $admin->name }}</h3>
                            <h5 class="widget-user-desc">{{ $admin->email }}</h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle elevation-2" src="{{ asset('admin_assets/images/user2-160x160.jpg') }}" alt="User Avatar">
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col-sm-6 border-right">
                                    <div class="description-block">
                                        <h5 class="description-header">
                                            {{ $admin->locale }}
                                        </h5>
                                        <span class="description-text">{{ __('basecode/admin.label.locale') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-6">
                                    <div class="description-block">
                                        <h5 class="description-header">{{ $admin->created_at->format('F d, Y') }}</h5>
                                        <span class="description-text">{{ __('basecode/admin.users.registered_on') }}</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                    </div>
                    <!-- /.widget-user -->
                </div>
            </div>

            <div class="row justify-content-md-center">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-text-width"></i>
                                {{ __('basecode/admin.menus.roles') }}
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <ul>
                                @foreach ($admin->roles as $role)
                                <li>
                                    <a href="{{ route('admin.roles.show', $role) }}">{{ $role->name }}</a>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>
</script>
@endpush