@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.sub_admins');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">{{ $title }}</h3>

                                <div class="text-right">
                                    <a href="{{ route('admin.sub-admins.create') }}" class="btn btn-success">
                                        <i class="fas fa-plus"></i> {{ __('basecode/admin.label.add') }}
                                    </a>
                                </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <table id="js-table" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>{{ __('basecode/admin.label.name') }}</th>
                                            <th>{{ __('basecode/admin.label.email') }}</th>
                                            <th>{{ __('basecode/admin.menus.roles') }}</th>
                                            <th>{{ __('basecode/admin.label.active') }}</th>
                                            <th>{{ __('basecode/admin.label.created_at') }}</th>
                                            <th>{{ __('basecode/admin.label.updated_at') }}</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>#</th>
                                            <th>{{ __('basecode/admin.label.name') }}</th>
                                            <th>{{ __('basecode/admin.label.email') }}</th>
                                            <th>{{ __('basecode/admin.menus.roles') }}</th>
                                            <th>{{ __('basecode/admin.label.active') }}</th>
                                            <th>{{ __('basecode/admin.label.created_at') }}</th>
                                            <th>{{ __('basecode/admin.label.updated_at') }}</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>

    const table = $('#js-table').on('preXhr.dt', function (e, settings, data) {
        if (settings.jqXHR) {
            settings.jqXHR.abort(); // cancel previous ajax request
        }
    }).DataTable({
        stateSave: true,
        dom: '<"datatable-header"fl><"datatable-scroll"rt><"datatable-footer"ip>',
        serverSide: true,
        columnDefs: [{
            orderable: false,
            targets: [0, 3]
        }, {
            searchable: false,
            targets: [0, 3]
        }],
        ajax: {
            url: "{{ route('admin.sub-admins.index') }}",
            beforeSend: function () {
                $('#js-roles-table tbody').html(
                    `<tr class="text-center">
                        <td colspan="${$('#js-table').find('th').length}">
                            <i class="fa fa-spinner fa-spin"></i> Loading...
                        </td>
                    </tr>`
                );
            }
        },
        order: [[0, "desc"]],
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name'},
            {data: 'email'},
            {data: 'roles', name: 'roles.name'},
            {data: 'is_active'},
            {
                data: 'created_at',
                type: 'num',
                render: {
                    _: 'display',
                    sort: 'timestamp'
                }
            },
            {
                data: 'updated_at',
                type: 'num',
                render: {
                    _: 'display',
                    sort: 'timestamp'
                }
            },
            {data: 'action', name: 'action', 'orderable': false, 'searchable': false},
        ],
        deferRender: true,
        initComplete: function(settings, json) {

            initializeActivate('admin.sub-admins.active', settings);
        }
    });
</script>
@endpush