@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.'.($isCreate ? 'create' : 'update').'_sub_admin');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> __('basecode/admin.menus.sub_admins'), 'target'=> route('admin.sub-admins.index')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
    
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-4">
                    @if (session('message'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ session('message') }}
                    </div>
                    @endif
                    <!-- general form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form method="POST" action="{{ 
                            $isCreate
                            ? route('admin.sub-admins.store')
                            : route('admin.sub-admins.update', $admin) 
                        }}">

                            @if(!$isCreate) @method('PUT') @endif

                            @csrf
                            <div class="card-body">

                                <div class="form-group">
                                    <label for="js-name">{{ __('basecode/admin.label.name') }}</label>
                                    <input 
                                    type="text" 
                                    name="name" 
                                    class="form-control @error('name') is-invalid @enderror" 
                                    id="js-name" 
                                    placeholder="{{ __('basecode/admin.placeholder.name') }}" 
                                    value="{{ old('name') ?? $admin->name ?? '' }}">

                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="js-email">{{ __('basecode/admin.label.email') }}</label>
                                    <input 
                                    type="text" 
                                    name="email" 
                                    class="form-control @error('email') is-invalid @enderror" 
                                    id="js-email" 
                                    placeholder="{{ __('basecode/admin.placeholder.email') }}" 
                                    value="{{ old('email') ?? $admin->email ?? '' }}">

                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>{{ __('basecode/admin.menus.roles') }}</label>
                                    <select 
                                    class="select2bs4 @error('roles') is-invalid @enderror" 
                                    name="roles[]" 
                                    multiple="multiple" 
                                    data-placeholder="{{ __('basecode/admin.placeholder.select_roles') }}">
                                    @foreach ($roles ?? [] as $role)
                                        <option value="{{ $role->getKey() }}" 
                                        @selected(in_array($role->id, old('roles') ?: (isset($admin) ? $admin->roles->modelKeys() : [])))>
                                            {{ $role->name }}
                                        </option>
                                    @endforeach
                                    </select>

                                    @error('roles')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                        <input type="checkbox" name="active" class="custom-control-input" id="js-active" @checked(old('active') ?? $admin->is_active ?? '')>
                                        <label class="custom-control-label" for="js-active">{{ __('basecode/admin.label.active') }}</label>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card-body -->
                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-secondary w-100">{{ __('basecode/admin.label.submit') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>
    $(function () {

        $('.select2bs4').select2({
            theme: 'bootstrap4',
            language: 'en',
            dir: 'ltr',
            width: '100%',
        });
    })
</script>
@endpush