@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.seeders_management');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
    
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                            <small class="ml-2 text-danger">{{ __('basecode/admin.messages.seeders_desc')}}</small>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="js-table" class="table table-bordered table-striped" data-ajax-url="">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('basecode/admin.label.file_path') }}</th>
                                        <th>{{ __('basecode/admin.label.updated_at') }}</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($files as $index => $file)
                                        <tr>
                                            <td>{{ $index+1 }}</td>
                                            <td>{{ $file->getFilename() }}</td>
                                            <td>{{ date('Y-m-d h:i:s A', $file->getmTime()) }}</td>
                                            <td>
                                                <button 
                                                class="btn btn-success btn-sm js-execute-action-handle" 
                                                data-seeder-path-name="{{ $file->getRelativePathname() }}">Execute</button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        
                                        <th
                                        data-filter-type="text" 
                                        data-filter-id="js-search-file-path-at" 
                                        data-filter-name="file_path">{{ __('basecode/admin.label.file_path') }}</th>
                                        
                                        <th 
                                        data-filter-type="date" 
                                        data-filter-id="js-search-updated-at" 
                                        data-filter-name="updated_at">{{ __('basecode/admin.label.updated_at') }}</th>
                                        
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
</div>
@endsection

@push('scripts')
    <script>
        
        const table = $('#js-table').on('preXhr.dt', function (e, settings, data) {
            if (settings.jqXHR) {
                settings.jqXHR.abort(); // cancel previous ajax request
            }
        }).DataTable({
            // stateSave: true,
            dom: '<"datatable-header"fl><"datatable-scroll"rt><"datatable-footer"ip>',
            serverSide: false,
            order: [
                [0, "desc"]
            ],
            columnDefs: [{
                width: "5%", 
                targets: [0, 3] 
            },{ 
                width: "10%", 
                targets: [1, 2] 
            },{
                orderable: false,
                targets: [0, 1, 3]
            }, {
                searchable: false,
                targets: [0, 3]
            }],
            deferRender: true,
            initComplete: function(settings, json) {

                const dataTableFilters = new DataTableFilters();
                dataTableFilters.initializeFilter(this);
                initializeActivate('admin.users.active');
            }
        });


        let runningAJAX;
        let counterInstance;
        $('.js-execute-action-handle').on('click', function() {
            
            const btn = $(this);
            const btnText = btn.html();

            runningAJAX = $.ajax({
                url: route('admin.settings.seeders.execute'),
                method: 'POST',
                data: {
                    seeder_path_name: btn.data('seeder-path-name')
                },
                beforeSend: function () {
                    counter(btn, 10, () => {
                        runningAJAX.abort();
                    });
                    lockTheButton(btn, '');
                },
                success: function (res) {
                    showToast(res.message);
                },
                complete: function () {
                    clearInterval(counterInstance);
                    unlockTheButton(btn, btnText);
                    table.draw(false);
                },
                error: function (jqXhr, textStatus, errorThrown) {
                    
                    jqXhr.responseJSON = {
                        message: 'Your request was aborted due since it\'s taking much time.'
                    }
                    
                    showToast(handleAnErrorAJAX(jqXhr, textStatus), false);
                }
            });
        });
    </script>
@endpush