@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.mobile_management');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
    
    <section class="content">
        @if (session('message'))
        <div class="alert alert-success text-center" role="alert">
            {{ session('message') }}
        </div>
        @endif
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-4">
                    <!-- general form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('basecode/admin.mobile_management.version_management') }}</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form id="js-app-configuration-form" method="POST" action="{{ route('admin.settings.mobile') }}">
                            @method('PATCH')
                            @csrf
                            <div class="card-body">
                                <div class="row col-12 mb-1">
                                    <small class="text-danger text-center">
                                        {{ __('basecode/admin.messages.app_version_note')}}
                                    </small>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="js-android-version">{{ __('basecode/admin.mobile_management.android_version') }}</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text"><i class="fa-brands fa-android"></i></span>
                                                </div>
                                                <input type="text" name="android[version]" class="form-control @error('android.version') is-invalid @enderror"
                                                    id="js-android-version" placeholder="{{ __('basecode/admin.placeholder.android_version') }}" value="{{ old('android.version', $androidVersion['version']) }}">
                                            
                                                @error('android.version')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="js-android-force-update">{{ __('basecode/admin.mobile_management.force_update') }}</label>
                                            <div class="input-group">
                                                <input 
                                                type="checkbox" 
                                                id="js-android-force-update" 
                                                name="android[force_updateable]" 
                                                data-bootstrap-switch 
                                                data-off-color="danger"
                                                data-on-color="success"
                                                @error('android.force_updateable') is-invalid @enderror
                                                @checked($androidVersion['force_updateable'])>
                                                
                                                @error('android.force_updateable')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="js-ios-version">{{ __('basecode/admin.mobile_management.ios_version') }}</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text"><i class="fa-brands fa-apple"></i></span>
                                                </div>
                                                <input type="text" name="ios[version]" class="form-control @error('ios.version') is-invalid @enderror"
                                                    id="js-ios-version" placeholder="{{ __('basecode/admin.placeholder.ios_version') }}" value="{{ old('ios.version', $iosVersion['version']) }}">
                                        
                                                @error('ios.version')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="js-ios-force-update">{{ __('basecode/admin.mobile_management.force_update') }}</label>
                                            <div class="input-group">
                                                <input 
                                                type="checkbox" 
                                                id="js-ios-force-update" 
                                                name="ios[force_updateable]" 
                                                data-bootstrap-switch 
                                                data-off-color="danger"
                                                data-on-color="success"
                                                @error('ios.force_updateable') is-invalid @enderror
                                                @checked($iosVersion['force_updateable'])>
                                                
                                                @error('ios.force_updateable')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card-body -->
                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-secondary w-100 border border-dark">{{ __('basecode/admin.label.submit') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('scripts')
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        })

        $('#js-app-configuration-form button[type="submit"]').on('click', function(e) {

            e.preventDefault();
            Swal.fire({
                title: "{{ __('basecode/admin.messages.confirmation_message') }}",
                showDenyButton: true,
                confirmButtonText: "{{ __('basecode/admin.label.yes') }}",
                denyButtonText: "{{ __('basecode/admin.label.no') }}",
            }).then((result) => {
                if (result.isConfirmed) {
                    e.currentTarget.setAttribute('disabled', true);
                    document.getElementById("js-app-configuration-form").submit();
                }
            })
        });
    </script>
@endpush