@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.email_configuration');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    @if (session('message'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ session('message') }}
                    </div>
                    @endif
                    <!-- general form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form id="js-email-configuration-form" method="POST" action="{{ route('admin.settings.email.update') }}">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="js-mailer">{{ __('basecode/admin.email_configuration.mailer') }}</label>
                                            <small class="text-muted ml-1">[MAIL_MAILER]</small>
                                            <select name="mailer" @error('mailer') is-invalid @enderror class="form-control">
                                                @foreach ($mailers as $mailer)
                                                <option value="{{ $mailer }}" @selected((old('mailer') ?: $mailer)==$currentMailer)>{{ $mailer }}</option>
                                                @endforeach
                                            </select>
                                            @error('mailer')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="js-host">{{ __('basecode/admin.email_configuration.host') }}</label>
                                            <small class="text-muted ml-1">[MAIL_HOST]</small>
                                            <input type="text" name="host" class="form-control @error('host') is-invalid @enderror" id="js-host" placeholder="{{ __('basecode/admin.email_configuration.host') }}" value="{{old('host', $host)}}">
                                            @error('host')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="form-group">
                                            <label for="js-port">{{ __('basecode/admin.email_configuration.port') }}</label>
                                            <small class="text-muted ml-1">[MAIL_PORT]</small>
                                            <input type="text" name="port" class="form-control @error('port') is-invalid @enderror" id="js-port" placeholder="{{ __('basecode/admin.email_configuration.port') }}" value="{{old('port', $port)}}">
                                            @error('port')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="form-group">
                                            <label for="js-encryption">{{ __('basecode/admin.email_configuration.encryption') }}</label>
                                            <small class="text-muted ml-1">[MAIL_ENCRYPTION]</small>
                                            <select name="encryption" @error('encryption') is-invalid @enderror class="form-control">
                                                <option value="ssl" @selected((old('encryption') ?: $encryption)=='ssl' )>SSL</option>
                                                <option value="tls" @selected((old('encryption') ?: $encryption)=='tls' )>TLS</option>
                                            </select>
                                            @error('encryption')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">


                                        <div class="form-group">
                                            <label for="js-email">{{ __('basecode/admin.email_configuration.username') }}</label>
                                            <small class="text-muted ml-1">[MAIL_USERNAME]</small>
                                            <input type="text" name="username" class="form-control @error('username') is-invalid @enderror" placeholder="{{ __('basecode/admin.email_configuration.username') }}" id="js-username" value="{{old('username', $username)}}">
                                            @error('username')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="js-email">{{ __('basecode/admin.email_configuration.password') }}</label>
                                            <small class="text-muted ml-1">[MAIL_PASSWORD]</small>
                                            <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="js-password" placeholder="{{ __('basecode/admin.email_configuration.password') }}" value="{{old('password', $password)}}">
                                            @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="js-from_address">{{ __('basecode/admin.email_configuration.from_address') }}</label>
                                            <small class="text-muted ml-1">[MAIL_FROM_ADDRESS]</small>
                                            <input type="text" name="from_address" class="form-control @error('from_address') is-invalid @enderror" id="js-from_address" value="{{old('from_address', $address)}}">
                                            @error('from_address')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="js-email">{{ __('basecode/admin.email_configuration.from_name') }}</label>
                                            <small class="text-muted ml-1">[MAIL_FROM_NAME]</small>
                                            <input type="text" name="from_name" class="form-control @error('from_name') is-invalid @enderror" id="js-from_name" placeholder="{{ __('basecode/admin.email_configuration.from_name') }}" value="{{old('from_name', $from_name)}}">
                                            @error('from_name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <button type="submit" class="btn btn-secondary w-100 border border-dark">{{ __('basecode/admin.label.submit') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('scripts')
<script type="text/javascript">
    $('#js-email-configuration-form button[type="submit"]').on('click', function(e) {

        e.preventDefault();
        Swal.fire({
            title: "{{ __('basecode/admin.messages.confirmation_message') }}",
            showDenyButton: true,
            confirmButtonText: "{{ __('basecode/admin.label.yes') }}",
            denyButtonText: "{{ __('basecode/admin.label.no') }}",
        }).then((result) => {
            if (result.isConfirmed) {
                e.currentTarget.setAttribute('disabled', true);
                document.getElementById("js-email-configuration-form").submit();
            }
        })
    });
</script>
@endpush