@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.'.($isCreate ? 'create' : 'update').'_role');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> __('basecode/admin.menus.roles'), 'target'=> route('admin.roles.index')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
     
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-4">
                    @if (session('message'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ session('message') }}
                    </div>
                    @endif
                    <!-- general form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                        </div>
                        <!-- /.card-header -->

                        <!-- form start -->
                        <form method="POST" 
                            action="{{ 
                                $isCreate
                                ? route('admin.roles.store')
                                : route('admin.roles.update', $role) 
                            }}"
                            autocomplete="off">

                            @if(!$isCreate) @method('PUT') @endif
                            
                            @csrf
                            <div class="card-body">
                                
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="js-role-name">{{ __('basecode/admin.label.name') }}</label>
                                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" id="js-role-name" placeholder="Title"
                                            value="{{ old('name') ?? $role->name ?? '' }}">

                                        @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>{{ __('basecode/admin.menus.permissions') }}</label>
                                        <select 
                                        class="select2bs4 @error('permissions') is-invalid @enderror" 
                                        name="permissions[]" 
                                        multiple="multiple" 
                                        data-placeholder="{{ __('basecode/admin.placeholder.select_permissions') }}">
                                        @foreach ($permissions as $permission)
                                            <option value="{{ $permission->getKey() }}" 
                                            @selected(in_array($permission->id, old('permissions') ?: (isset($role) ? $role->permissions->modelKeys() : [])))>
                                                {{ $permission->name }}
                                            </option>
                                        @endforeach
                                        </select>

                                        @error('permissions')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    <!-- /.form-group -->
                                </div>
                            </div>
                            <!-- /.card-body -->
    
                            <div class="card-footer">
                                <button type="submit" class="btn btn-secondary w-100">{{ __('basecode/admin.label.submit') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>
    $(function () {

        $('.select2bs4').select2({
            theme: 'bootstrap4',
            language: 'en',
            dir: 'ltr',
            width: '100%',
        });
    })
</script>
@endpush