@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.permissions');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>

                            <div class="text-right">
                                <a href="javascript:;" class="btn btn-success" id="js-add-modal-btn">
                                    <i class="fas fa-plus"></i> {{ __('basecode/admin.label.add') }}
                                </a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="js-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('basecode/admin.label.name') }}</th>
                                        <th>{{ __('basecode/admin.label.created_at') }}</th>
                                        <th>{{ __('basecode/admin.label.updated_at') }}</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                       <th>#</th>
                                        <th>{{ __('basecode/admin.label.name') }}</th>
                                        <th>{{ __('basecode/admin.label.created_at') }}</th>
                                        <th>{{ __('basecode/admin.label.updated_at') }}</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
</div>
<div id="js-create-modal"></div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>

    $(document).on('click', '#js-add-modal-btn', function() {
        axios({
            url: "{{ route('admin.permissions.create') }}",
        })
        .then(function (response) {
            $('#js-create-modal').html(response.data);
            $('#js-create-modal').find('.modal').modal('show');
        })
        .catch(function (error) {
            showToast(handleAnError(error), false)
        });
    });

    $(document).on('click', '.js-edit-modal-btn', function() {

        axios({
            url: $(this).data('href')
        })
        .then(function (response) {
            $('#js-create-modal').html(response.data);
            $('#js-create-modal').find('.modal').modal('show');
        })
        .catch(function (error) {
            showToast(handleAnError(error), false)
        });
    });

    const table = $('#js-table').on('preXhr.dt', function (e, settings, data) {
        if (settings.jqXHR) {
            settings.jqXHR.abort(); // cancel previous ajax request
        }
    }).DataTable({
        stateSave: true,
        dom: '<"datatable-header"fl><"datatable-scroll"rt><"datatable-footer"ip>',
        serverSide: true,
        columnDefs: [{
            orderable: false,
            targets: [0, 3]
        }, {
            searchable: false,
            targets: [0, 3]
        }],
        ajax: {
            url: "{{ route('admin.permissions.index') }}",
            beforeSend: function () {
                $('#js-roles-table tbody').html(
                    `<tr class="text-center">
                        <td colspan="${$('#js-table').find('th').length}">
                            <i class="fa fa-spinner fa-spin"></i> Loading...
                        </td>
                    </tr>`
                );
            }
        },
        order: [[0, "desc"]],
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name'},
            {
                data: 'created_at',
                type: 'num',
                render: {
                    _: 'display',
                    sort: 'timestamp'
                }
            },
            {
                data: 'updated_at',
                type: 'num',
                render: {
                    _: 'display',
                    sort: 'timestamp'
                }
            },
            {data: 'action', name: 'action', 'orderable': false, 'searchable': false},
        ],
        deferRender: true
    });

    $(document).on('submit', '#js-permission-form', function(e) {
        e.preventDefault();

        const form = $('#js-permission-form');
        const modal = $(form).closest('.modal');
        axios({
            url: form.attr('action'),
            method: form.find('input[name=_method]').val(),
            data: form.serialize()
        })
        .then(function (response) {
            modal.modal('hide');
            table.ajax.reload(null, false);
            showToast(response.data.message);
        })
        .catch(function (error) {
            showToast(handleAnError(error), false)
        });
    });
</script>
@endpush
