<div class="modal fade" id="js-add-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{ 
                        $isCreate 
                        ? __('basecode/admin.menus.create_permission') 
                        : __('basecode/admin.menus.update_permission')
                    }}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="js-permission-form" 
                method="POST" 
                action="{{ 
                    $isCreate 
                    ? route('admin.permissions.store') 
                    : route('admin.permissions.update', $permission) 
                }}" 
                autocomplete="OFF">
                <div class="modal-body">
                    @csrf
                    @method($isCreate ? 'POST': 'PATCH')
                    <div class="card-body p-0">
                
                        <div class="form-group">
                            <label for="js-name">{{ __('basecode/admin.label.name') }}</label>
                            <input type="text" 
                                name="name" 
                                class="form-control" 
                                id="js-name"
                                placeholder="{{ __('basecode/admin.placeholder.permission') }}" 
                                value="{{ old('name', $permission->name ?? '') }}">
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ __('basecode/admin.label.close') }}</button>
                    <button type="submit" class="btn btn-secondary">{{ __('basecode/admin.label.save') }}</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
