@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.update_password');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
    
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-4">
                    @if (session('message'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ session('message') }}
                    </div>
                    @endif
                    <!-- general form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form method="POST" action="{{ route('admin.my-account.password.update') }}">

                            @csrf
                            <div class="card-body">

                                <div class="form-group">
                                    <label for="js-email">{{ __('basecode/admin.label.email') }}</label>
                                    <input type="text" name="current_password" class="form-control @error('current_password') is-invalid @enderror" id="js-email" placeholder="{{ __('basecode/admin.placeholder.email') }}" autocomplete="current-password" value="{{ auth()->user()->email }}" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="js-current-password">{{ __('basecode/admin.update_password.current_password') }}</label>
                                    <input type="password" name="current_password" class="form-control @error('current_password') is-invalid @enderror" id="js-current-password" placeholder="Current Password" autocomplete="current-password">

                                    @error('current_password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="js-new-password">{{ __('basecode/admin.update_password.new_password') }}</label>
                                    <input type="password" name="new_password" class="form-control @error('new_password') is-invalid @enderror" id="js-new-password" placeholder="New Password" autocomplete="new-password">

                                    @error('new_password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="js-confirm-new-password">{{ __('basecode/admin.update_password.confirm_new_password') }}</label>
                                    <input type="password" name="new_password_confirmation" class="form-control" id="js-confirm-new-password" placeholder="Confirm New Password" autocomplete="new-password">
                                </div>
                            </div>
                            <!-- /.card-body -->
                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-secondary w-100">{{ __('basecode/admin.label.submit') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection