@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.countries');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>

                            <div class="text-right">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-success">{{ __('basecode/admin.table.action') }}</button>
                                    <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown">
                                        <span class="sr-only">{{ __('basecode/admin.table.select_action') }}</span>
                                    </button>
                                    <div class="dropdown-menu" role="menu">
                                        <a class="dropdown-item js-bulk-active" data-activate="1" href="javascript:;">{{ __('basecode/admin.table.bulk_activate') }}</a>
                                        <a class="dropdown-item js-bulk-active" data-activate="0" href="javascript:;">{{ __('basecode/admin.table.bulk_inactivate') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="js-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('basecode/admin.label.name') }}</th>
                                        <th>{{ __('basecode/admin.label.code') }}</th>
                                        <th>{{ __('basecode/admin.label.isd_code') }}</th>
                                        <th>{{ __('basecode/admin.label.currency') }}</th>
                                        <th>{{ __('basecode/admin.label.flag') }}</th>
                                        <th>{{ __('basecode/admin.label.active') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('basecode/admin.label.name') }}</th>
                                        <th>{{ __('basecode/admin.label.code') }}</th>
                                        <th>{{ __('basecode/admin.label.isd_code') }}</th>
                                        <th>{{ __('basecode/admin.label.currency') }}</th>
                                        <th>{{ __('basecode/admin.label.flag') }}</th>
                                        <th>{{ __('basecode/admin.label.active') }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>
    const table = $('#js-table').on('preXhr.dt', function (e, settings, data) {
        if (settings.jqXHR) {
            settings.jqXHR.abort(); // cancel previous ajax request
        }
    }).DataTable({
        stateSave: true,
        dom: '<"datatable-header"fl><"datatable-scroll"rt><"datatable-footer"ip>',
        serverSide: true,
        columnDefs: [{
            orderable: false,
            targets: [0, 5, 6]
        }, {
            searchable: false,
            targets: [0, 5, 6]
        }],
        ajax: {
            url: "{{ route('admin.countries.index') }}",
            beforeSend: function () {
                $('#js-roles-table tbody').html(
                    `<tr class="text-center">
                        <td colspan="${$('#js-table').find('th').length}">
                            <i class="fa fa-spinner fa-spin"></i> Loading...
                        </td>
                    </tr>`
                );
            }
        },
        order: [[0, "desc"]],
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name'},
            {data: 'code'},
            {data: 'isd_code'},
            {data: 'currency_code'},
            {data: 'emoji'},
            {data: 'is_active'},
        ],
        deferRender: true,
        initComplete: function(settings, json) {

            initializeActivate('admin.countries.active', settings);
            initializeBulkActivate('admin.countries.bulk-active', settings);
        }
    });
</script>
@endpush