@extends('admin.layouts.app')

@section('content')

@php
$title = 'Content Page Detail';
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> __('basecode/admin.menus.content_pages'), 'target'=> route('admin.content-pages.index')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
    
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-12">
                    @if (session('message'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ session('message') }}
                    </div>
                    @endif
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                            <div class="text-right">
                                <a href="{{ route('admin.content-pages.edit',['content_page' => $contentPage]) }}" class="btn btn-warning">
                                    <i class="fa fa-edit"></i> {{ __('basecode/admin.label.edit') }}
                                </a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered table-striped">
                                <tr>
                                    <th style="width: 300px;">{{ __('basecode/admin.label.slug') }}</th>
                                    <td>{{ $contentPage->slug }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('basecode/admin.label.title') }}</th>
                                    <td>{{ $contentPage->title }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('basecode/admin.content_pages.content') }}</th>
                                    <td>{!! $contentPage->content !!}</td>
                                </tr>
                                <tr>
                                    <th style="width: 300px;">{{ __('basecode/admin.label.updated_at') }}</th>
                                    <td>{{ $contentPage->updated_at->diffForHumans() }}</td>
                                </tr>
                                <tr>
                                    <th style="width: 300px;">{{ __('basecode/admin.label.created_at') }}</th>
                                    <td>{{ $contentPage->created_at->format('Y-m-d h:i A') }}</td>
                                </tr>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
</div>
@endsection