@extends('admin.layouts.app')

@section('content')

@php
$title = __('basecode/admin.menus.'.($isCreate ? 'create' : 'update').'_content_pages');
$links = [
    ['name'=> __('basecode/admin.menus.dashboard'), 'target'=> route('admin.home')],
    ['name'=> __('basecode/admin.menus.content_pages'), 'target'=> route('admin.content-pages.index')],
    ['name'=> $title, 'target'=> '']
];
@endphp

<div class="content-wrapper" style="min-height: 1345.31px;">

    <x-admin.breadcrumb :title="$title" :links="$links"></x-admin.bradcrumb>
     
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    @if (session('message'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ session('message') }}
                    </div>
                    @endif
                    <!-- general form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">{{ $title }}</h3>
                        </div>
                        <!-- /.card-header -->

                        <!-- form start -->
                        <form method="POST" 
                            action="{{ 
                                $isCreate
                                ? route('admin.content-pages.store')
                                : route('admin.content-pages.update', $contentPage) 
                            }}">

                            @if(!$isCreate) @method('PUT') @endif
                            
                            @csrf
                            <div class="card-body">
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="js-title">{{ __('basecode/admin.label.title') }}</label>
                                            <input type="text" 
                                                name="title" 
                                                class="form-control @error('title') is-invalid @enderror" 
                                                id="js-title"
                                                placeholder="Title"
                                                value="{{ old('title') ?? $contentPage->title ?? '' }}">
                                        
                                            @error('title')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="js-slug">{{ __('basecode/admin.label.slug') }}</label>
                                            <input type="text" 
                                                name="slug" 
                                                class="form-control @error('slug') is-invalid @enderror" 
                                                id="js-slug"
                                                placeholder="Slug"
                                                value="{{ old('slug') ?? $contentPage->slug ?? '' }}">
                                        
                                            @error('slug')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="js-content">{{ __('basecode/admin.content_pages.content') }}</label>
                                    <textarea name="content" 
                                        class="form-control @error('content') is-invalid @enderror" 
                                        id="js-content" 
                                        placeholder="Write some text here.."
                                        rows="10">{{ old('content') ?? $contentPage->content ?? '' }}</textarea>
                                        
                                    @error('content')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- /.card-body -->
    
                            <div class="card-footer">
                                <button type="submit" class="btn btn-secondary w-100">{{ __('basecode/admin.label.submit') }}</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

<!--- Append javascript --->
@push('scripts')
<script>
    $(function () {
        $('#js-content').summernote({
            height: 250
        })
    })
</script>
@endpush