@extends('admin.layouts.app')

@section('content')
<div class="login-box">
    <div class="card card-outline card-primary">
        <div class="card-header text-center">
            <a href="{{ route('admin.password.request') }}" class="h3"><b>{{ config('app.name') }}</b></a>
        </div>
        <div class="card-body">
            @if (session('status'))
                <div class="alert alert-success text-center" role="alert">
                    {{ session('status') }}
                </div>
            @endif
            <p class="login-box-msg">{{ __('basecode/admin.messages.forgot_password_desc') }}</p>
            <form action="{{ route('admin.password.email') }}" method="POST">

                @csrf
                <div class="input-group mb-3">
                    <input type="email" class="form-control @error('email') is-invalid @enderror" placeholder="{{ __('basecode/admin.placeholder.email') }}" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>

                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary btn-block">{{ __('basecode/admin.label.send_password_link') }}</button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>
            <p class="mt-3 mb-1">
                <a href="{{ route('admin.login') }}">{{ __('basecode/admin.label.sign_in') }}</a>
            </p>
        </div>
        <!-- /.login-card-body -->
    </div>
</div>
@endsection
