class DataTableFilters {

    constructor() {}

    validate() {
        

        if (this.ID === undefined) {

            throw new Error('data-filter-id attribute is not found');
        }

        if (this.name === undefined) {

            throw new Error('data-filter-name attribute is not found');
        }
    }

    render() {
        $(this.footer).html(this.element);
        return this;
    }

    initializeFilter(table) {

        const hasFilter = $(table).find('tfoot th[data-filter-type]').length > 0;

        if (hasFilter === false) {
            return false;
        }

        const footerRow = table.find('tfoot tr');
        const header = table.find('thead');
        footerRow.appendTo(header);
        
        table.api().columns().every(function (e) {

            const column = this;
            const footer = $(this.footer());

            const filter = footer.data('filter-type');
            
            if(!['text', 'select', 'date', 'date-range'].includes(filter)) {
                footer.html('');
                return;
            }
            
            const filterOptions = {
                footer: footer,
                column: column,
            };
            
            if(filter === 'text') {

                const inputFilter = new InputFilter(filterOptions);
                inputFilter.render().initialize().postAction();
            } else if (filter === 'select') {
                
                const selectFilter = new SelectFilter(filterOptions);
                selectFilter.render().initialize().postAction();
            } else if (filter === 'date') {
                
                const dateFilter = new DateFilter(filterOptions);
                dateFilter.render().initialize().postAction();
            } else if (filter === 'date-range') {
                
                const dateFilter = new DateRangeFilter(filterOptions);
                dateFilter.render().initialize().postAction();
            }
        });
    }
}

class InputFilter extends DataTableFilters {

    constructor({footer, column}) {
        
        super();
        
        this.footer = footer;
        this.column = column;

        this.ID = footer.data('filter-id');
        this.name = footer.data('filter-name');
        this.classes = 'font-normal	block w-full rounded-md border-0 py-1.5 px-3 text-gray-900 dark:text-gray-300 shadow-sm ring-1 ring-gray-300 dark:ring-gray-600 placeholder:text-gray-400 outline-none focus:outline-0 sm:text-sm sm:leading-6 dark:bg-transparent h-[40px]';
        if(footer.data('filter-classes') !== undefined) {
            this.classes += ' ' + footer.data('filter-classes');
        }

        this.validate();
        this.createElement();
    }

    createElement() {
        const input = document.createElement("input");
        input.type = "text";
        input.id = this.ID;
        input.name = this.name;
        input.className = this.classes;

        this.element = input;
        return this;
    }

    initialize() {

        return this;
    }

    postAction() {
        const that = this;
        $(`#${this.ID}`).on('keyup clear', function () {
            that.column.search($(this).val()).draw();
        });
        return this;
    }
}

class SelectFilter extends DataTableFilters {

    constructor({footer, column}) {
        
        super();
        
        this.footer = footer;
        this.column = column;

        this.ID = footer.data('filter-id');
        this.name = footer.data('filter-name');
        this.options = footer.data('filter-options');
        this.classes = 'block w-full rounded-md border-0 py-1.5 px-3 text-gray-900 dark:text-gray-300 shadow-sm ring-1 ring-gray-300 dark:ring-gray-600 placeholder:text-gray-400 outline-none focus:outline-0 sm:text-sm sm:leading-6 dark:bg-transparent h-[40px] custom-class';
        if(footer.data('filter-classes') !== undefined) {
            this.classes += ' ' + footer.data('filter-classes');
        }
        
        this.validate();
        this.createElement();
    }

    validate() {
        

        if (this.ID === undefined) {

            throw new Error({
                message: 'ID attribute is not found'
            });
        }

        if (this.name === undefined) {

            throw new Error({
                message: 'name attribute is not found'
            });
        }

        if (this.options === undefined || !Array.isArray(this.options)) {

            throw new Error({
                message: 'name attribute is not found'
            });
        }
    }


    createElement() {
        const select = document.createElement("select");
        select.id = this.ID;
        select.name = this.name;
        select.className = this.classes;
        const options = this.footer.data('filter-options');
    
        this.options.forEach((selectOption) => {
            const option = document.createElement("option");
            option.text = selectOption.text;
            option.value = selectOption.value;
            select.appendChild(option);
        });

        this.element = select;
        return this;
    }

    initialize() {
        return this;
    }

    postAction() {
        const that = this;
        $(`#${this.ID}`).on('change keyup clear', function () {
            that.column.search($(this).val()).draw();
        });
        return this;
    }
}

class DateFilter extends DataTableFilters {

    constructor({footer, column}) {
        
        super();
        
        this.footer = footer;
        this.column = column;

        this.ID = footer.data('filter-id');
        this.name = footer.data('filter-name');
        this.classes = 'block w-full rounded-md border-0 py-1.5 px-3 text-gray-900 dark:text-gray-300 shadow-sm ring-1 ring-gray-300 dark:ring-gray-600 placeholder:text-gray-400 outline-none focus:outline-0 sm:text-sm sm:leading-6 dark:bg-transparent h-[40px]';
        if(footer.data('filter-classes') !== undefined) {
            this.classes += ' ' + footer.data('filter-classes');
        }

        this.validate();
        this.createElement();
    }

    createElement() {
        this.element = `
            <div class="input-group date" id="${this.ID}" data-target-input="nearest">
                <input type="text" name="${this.name}" class="datetimepicker-input ${this.classes}" data-target="#${this.ID}" readonly="readonly"/>
                <div class="input-group-append" data-target="#${this.ID}" data-toggle="datetimepicker">
                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                </div>
            </div>
        `;
        return this;
    }

    initialize() {
        $(`#${this.ID}`).datetimepicker({
            format: 'L',
            ignoreReadonly: true,
            allowInputToggle: true,
            debug: true,
            buttons: {
                showToday: true,
                showClear: true,
                showClose: true
            }
        });
        return this;
    }

    postAction() {
        $(`#${this.ID}`).on('change.datetimepicker', ({date, oldDate}) => {
            if(oldDate !== null) {
                this.column.search(
                    date ? date.format('YYYY-MM-DD') : ''
                ).draw()
            }
        });
        return this;
    }
}

class DateRangeFilter extends DataTableFilters {

    constructor({footer, column}) {
        
        super();
        
        this.footer = footer;
        this.column = column;

        this.ID = footer.data('filter-id');
        this.name = footer.data('filter-name');
        this.classes = 'block w-full rounded-md border-0 py-1.5 px-3 pl-10 text-gray-900 dark:text-gray-300 shadow-sm ring-1 ring-gray-300 dark:ring-gray-600 placeholder:text-gray-400 outline-none focus:outline-0 sm:text-sm sm:leading-6 dark:bg-transparent h-[40px]';
        if(footer.data('filter-classes') !== undefined) {
            this.classes += ' ' + footer.data('filter-classes');
        }

        this.validate();
        this.createElement();
    }

    createElement() {
        this.element = `
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="far fa-calendar-alt p-3 absolute"></i>
                    </span>
                </div>
                <input type="text" name="${this.name}" class="${this.classes} float-right" id="${this.ID}" readonly="readonly">
            </div>
        `;
        return this;
    }

    initialize() {
        $(`#${this.ID}`).daterangepicker({
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear'
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        })
        return this;
    }

    postAction() {

        const that = this;
        $(`#${this.ID}`).on('apply.daterangepicker', (ev, picker) => {
            

            picker.element.val(
                `${picker.startDate.utc().format('YYYY-MM-DD hh:mm:ss a')} - ${picker.endDate.utc().format('YYYY-MM-DD hh:mm:ss a')}`
            );
            this.column.search(
                `${picker.startDate.utc().format('YYYY-MM-DD')}TO${picker.endDate.utc().format('YYYY-MM-DD')}`
            ).draw()
        }).on('cancel.daterangepicker', function(ev, picker) {

            picker.element.val('');
            that.column.search('').draw()
        });
        return this;
    }
}

const initializeActivate = (routeName, settings, is_active) => {

    const api = new $.fn.dataTable.Api(settings);
    $(document).on('click', '.js-active', function() {

        axios({
            url: route(routeName, {
                id: $(this).data('id')
            }),
            method: 'PATCH'
        })
        .then(function (response) {
            is_active.value = true
            api.ajax.reload(null, false);
            setTimeout(function(){
                is_active.value = false
            }, 5000);
        })
        .catch(function (error) {
            showToast(handleAnError(error), false)
        });
    });
}

const initializeUpdateStatus = (routeName, settings, Swal) => {

    const api = new $.fn.dataTable.Api(settings);
    $(document).on('change', '.air-transpot-update-status', function () {
        let requestData = {
            request_status: $(this).val()
        };
        if ($(this).val() === '2') {

            Swal.fire({
                icon: '',
                title: 'Submit your Reason',
                input: 'text',
                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                showLoaderOnConfirm: true,
                padding: '2em',
                customClass: 'sweet-alerts',
                preConfirm: async (data) => {
                    requestData.reason = data
                    axios({
                        url: route(routeName, {
                            air_transportation: $(this).data('order-id')
                        }),
                        method: 'POST',
                        data: requestData
                    })
                        .then(function (response) {
                            api.ajax.reload(null, false);
                        })
                        .catch(function (error) {
                            showToast(handleAnError(error), false)
                        });
                },
            }).then((result) => {
                if (!result.isConfirmed) {
                    api.ajax.reload(null, false);
                }
              })
        } else {
            axios({
                url: route(routeName, {
                    air_transportation: $(this).data('order-id')
                }),
                method: 'POST',
                data: requestData
            })
                .then(function (response) {
                    api.ajax.reload(null, false);
                })
                .catch(function (error) {
                    showToast(handleAnError(error), false)
                });
        }


    });
}

const initializeBulkActivate = (routeName, settings) => {

    const api = new $.fn.dataTable.Api(settings);
    $(document).on('click', '.js-bulk-active', function() {

        axios({
            url: route(routeName, {
                activate: $(this).data('activate')
            }),
            method: 'PATCH'
        })
        .then(function (response) {

            api.ajax.reload(null, false);
        })
        .catch(function (error) {
            showToast(handleAnError(error), false)
        });
    });
}

const AssignDriver = (routeName, settings, isOpen) => {
    const api = new $.fn.dataTable.Api(settings);
    $(document).on('click', '.assign-driver', function () {
        isOpen.value = true;
    });
}

const initializeDriverUpdateStatus = (routeName, settings, Swal) => {
    const api = new $.fn.dataTable.Api(settings);
    $(document).on('change', '.update-status', function () {
        let requestData = {
            status: $(this).val()
        };
        if ($(this).val() == 2) {
            Swal.fire({
                icon: '',
                title: 'Submit your Reason',
                input: 'text',
                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                showLoaderOnConfirm: true,
                padding: '2em',
                customClass: 'sweet-alerts',
                preConfirm: async (data) => {
                    requestData.reason = data
                    axios({
                        url: route(routeName, {
                            id: $(this).data('order-id')
                        }),
                        method: 'POST',
                        data: requestData
                    })
                        .then(function (response) {
                            api.ajax.reload(null, false);
                        })
                        .catch(function (error) {
                            showToast(handleAnError(error), false)
                        });
                },
            }).then((result) => {
                if (!result.isConfirmed) {
                    api.ajax.reload(null, false);
                }
              })
        } else {
            axios({
                url: route(routeName, {
                    id: $(this).data('order-id')
                }),
                method: 'POST',
                data: requestData
            })
                .then(function (response) {
                    api.ajax.reload(null, false);
                })
                .catch(function (error) {
                    showToast(handleAnError(error), false)
                });
        }


    });
}

const initializeOccupy = (routeName, settings) => {

    const api = new $.fn.dataTable.Api(settings);
    $(document).on('click', '.js-occupy', function() {

        axios({
            url: route(routeName, {
                id: $(this).data('id')
            }),
            method: 'PATCH'
        })
        .then(function (response) {

            api.ajax.reload(null, false);
        })
        .catch(function (error) {
            showToast(handleAnError(error), false)
        });
    });
}