import { createApp, h } from "vue";
import { createInertiaApp, Link, Head } from "@inertiajs/inertia-vue3";
import { InertiaProgress } from "@inertiajs/progress";
import CKEditor from '@ckeditor/ckeditor5-vue';
import VueSweetalert2 from 'vue-sweetalert2';
import VueTelInput from 'vue-tel-input';
import 'vue-tel-input/vue-tel-input.css';
import VOtpInput from "vue3-otp-input";
import { ZiggyVue } from "ziggy";
import { Ziggy } from "./ziggy";
import { StripeElementCard } from '@vue-stripe/vue-stripe';
import { StripePlugin } from '@vue-stripe/vue-stripe';
import VueApexCharts from "vue3-apexcharts";

const globalOptions = {
    mode: 'international',
};
InertiaProgress.init();

createInertiaApp({
    resolve: async (name) => {
        // Check if the name includes a subfolder
        if (name.includes('/')) {
            const [folder, page] = name.split('/');
            return (await import(`./Pages/${folder}/${page}`)).default;
        }

        return (await import(`./Pages/${name}`)).default;

    },
    setup({ el, App, props, plugin }) {
        createApp({ render: () => h(App, props) })
            .use(plugin)
            .use(ZiggyVue, Ziggy)
            .component("Link", Link)
            .component("Head", Head)
            .mixin({ methods: { route } })
            .use(CKEditor)
            .use(VueSweetalert2)
            .use(VueTelInput, globalOptions)
            .component('v-otp-input', VOtpInput)
            .component("stripe-element-card", StripeElementCard)
            .use(VueApexCharts)
            .mount(el);
    },
});