class DataTable {


    wantsToSaveState() {
        this.stateSave = true;
    }

    isServerSide() {
        this.serverSide = true;
    }

    setColumnDefs(columnDefs) {
        this.columnDefs = columnDefs
    }

    columns(columns) {
        this.columns = columns;
    }

    setOrdering(sortOrdering) {
        this.sortOrdering = sortOrdering;
    }

    remoteURL (url) {
        this.url = url;
    }

    init() {
        $(element).on('preXhr.dt', function (e, settings, data) {
            if (settings.jqXHR) {
                settings.jqXHR.abort(); // cancel previous ajax request
            }
        }).DataTable({
            stateSave: this.stateSave,
            dom: '<"datatable-header"fl><"datatable-scroll"rt><"datatable-footer"ip>',
            serverSide: this.serverSide,
            columnDefs: this.columnDefs ,
            ajax: {
                url: this.url,
                beforeSend: function () {
                    $('#js-table tbody').html(
                        `<tr class="text-center">
                            <td colspan="${$(element).find('th').length}">
                                <i class="fa fa-spinner fa-spin"></i> Loading...
                            </td>
                        </tr>`
                    );
                }
            },
            order: this.sortOrdering,
            columns: this.columns,
            deferRender: true
        })
    }
}