const handleAnError = (obj) => {

    let msg = '';

    if(!obj.response) {
        return obj.message;
    }

    // if (axios.isCancel(obj)) {
    //     msg = 'Ajax request is aborted.';
    // }

    if (obj.response.status === 0) {
        msg = 'Not connect.\n Verify Network.';
    } else if (obj.response.status == 404) {
        msg = 'Requested page not found. [404]';
    } else if (obj.response.status == 500) {
        if (obj.file) {
            msg = `${obj.response.data.message} in file ${obj.file} at line ${obj.line}`;
        } else {
            msg = obj.response.data.message;
        }
    } else if (obj.response.status == 422 || obj.response.status == 429) {
        msg = obj.errors;
        if (msg === undefined) {
            // user generated error
            msg = obj.response.data.message;
        } else {
            // laravel generated error
            msg = msg[Object.keys(msg)[0]][0];
        }
    } else if (obj.response.statusText === 'parsererror') {
        msg = 'Requested JSON parse failed.';
    } else if (obj.response.statusText === 'timeout') {
        msg = 'Time out error.';
    } else if (obj.response.statusText === 'abort') {
        msg = 'Ajax request aborted.';
    } else {
        msg = obj.response.data.message;
    }
    return msg;
}

function handleAnErrorAJAX(jqXHR, exception) {

    let msg = '';

    if (exception === 'abort') {

        if(jqXHR.responseJSON !== undefined) {
            return jqXHR.responseJSON.message;
        }
        return;
    }

    if (jqXHR.status === 0) {
        msg = 'Not connect.\n Verify Network.';
    } else if (jqXHR.status == 404) {
        msg = 'Requested page not found. [404]';
    } else if (jqXHR.status == 500) {
        if (!jqXHR.responseText) {
            msg = "Unknown error appeared."
        } else if (jqXHR.responseJSON.file) {
            msg = `${jqXHR.responseJSON.message} in file ${jqXHR.responseJSON.file} at line ${jqXHR.responseJSON.line}`;
        } else {
            msg = jqXHR.responseJSON.message;
        }
    } else if (jqXHR.status == 422 || jqXHR.status == 429) {
        msg = JSON.parse(jqXHR.responseText).errors;
        if (msg === undefined) {
            // user generated error
            msg = jqXHR.responseJSON.message;
        } else {
            // laravel generated error
            msg = msg[Object.keys(msg)[0]][0];
        }
    } else if (exception === 'parsererror') {
        msg = 'Requested JSON parse failed.';
    } else if (exception === 'timeout') {
        msg = 'Time out error.';
    } else if (exception === 'abort') {
        msg = 'Ajax request aborted.';
    } else {
        msg = jqXHR.responseJSON.message;
    }
    return msg;
} 

window.Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
});

window.showToast = (message, success = true) => {
    Toast.fire({
        icon: success ? 'success' : 'error',
        title: message
    });
}


window.addEventListener('DOMContentLoaded', () => {
    const flash = document.querySelector('div[role="alert"]');
    if (flash) {
        setTimeout(() => {
            flash.remove();
        }, 2000);
    }
});


// window.addEventListener('input', (event) => {
//     let errorElement = event.target.parentElement.parentElement;
//     console.log('step1');
//     if (event.target.type === 'file') {
//         errorElement = errorElement.parentElement;
//     }
//     console.log('step4');
//     const errorMsg = errorElement.querySelector('.text-red-600');
//     console.log('step2');
//     if (errorMsg) {
//         console.log('step3');
//         errorMsg.remove();
//     }
// });

