
const config = {
    apiKey: "AIzaSyAvAqaplOE_AJKLax9vVcW74yXRTPOtQeI",
    projectId: "u-app-2071c",
    messagingSenderId: "163625370621",
    appId: "1:163625370621:web:66768ccda71c963620cf94",
  };

firebase.initializeApp(config);

var messaging = firebase.messaging();

navigator.serviceWorker.register(BASE_URL+'/admin_assets/js/firebase-messaging-sw.js').then(function (registration) {
    messaging.useServiceWorker(registration);
    messaging.requestPermission().then(function () {
        messaging.getToken().then(function(token) {
            ajaxCall(token);
        })
        .catch(function(error) {
            console.log('Error while fetching the token ' + error);
        });
    }).catch(function (error) {
        console.log('Permission denied ' + error);
    })
}).catch(function (error) {
    console.log(error);
    console.log('Error in registering service worker');
});


messaging.onTokenRefresh(function() {
    messaging.getToken().then(function(renewedToken) {
        console.log('onTokenRefresh');
        ajaxCall(renewedToken);
    })
    .catch(function(error) {
        console.log('Error in fetching refreshed token ' + error);
    });
});

messaging.onMessage(function({data:{body,title}}){
    var icon = BASE_URL + "/images/logo.svg";
    console.log("Message received. ",title, {
        body: body,
        icon: icon
    });
    new Notification(title, {
        body: body,
        icon: icon
    });

    console.log("Message received. ",icon);
    console.log("Message received. ", body,title);
   
});

function ajaxCall(token){
   var url = BASE_URL + "/airtransport/add-token/"+ token;
    $.ajax({
        url: url,
        type: "get",
        data: {token: token},
        success: function(response) {
            console.log(response);
        },
        error: function(xhr, status, error) {
            console.log(xhr.responseText);
        }
    });
}