const express = require('express');
const { Socket } = require('socket.io');
const app = express();
var redis = require('ioredis');
var axios = require('axios');
const { Console } = require('console');
require('dotenv').config()
const fs = require('fs');
const cert = "";
const key = "";
const options = {
  key: fs.readFileSync(key),
  cert: fs.readFileSync(cert)
};
const server = require('https').createServer(options, app);

const port = process.env.PORT;
const host = process.env.APP_URL
console.log(host, port)
const io = require('socket.io')(server, {
  cors: {
    origin: "*",
    methods: ["GET", "POST"]
  }
});

// Array to store the connected drivers
const connectedUsers = [];
const connectedDrivers = [];

io.on('connection', (socket) => {
  console.log('connection');
  // Get the parameter from the query 
  const userType = socket.handshake.query.userType;
  const Id = socket.handshake.query.Id;

  // Handle different user types
  if (userType === 'driver') {
    const Id = socket.handshake.query.Id; // Get the driver ID from the query parameter
    // Add the driver information to the array
    const driverInfo = {
      id: Id,
      socketId: socket.id,
      // You can add more driver information here, such as name, location, etc.
    };
    const existingDriverIndex = connectedDrivers.findIndex((driver) => {
      return driver.id === Id;
    });
  
    if (existingDriverIndex !== -1) {
      // Remove the existing driver's record
      connectedDrivers.splice(existingDriverIndex, 1);
    }
    connectedDrivers.push(driverInfo);
    console.log(connectedDrivers);
    console.log('Driver connected:', Id, socket.id);
  }

  if (userType === 'user') {
    const Id = socket.handshake.query.Id; // Get the user ID from the query parameter
    // Add the user information to the array
    const userInfo = {
      id: Id,
      socketId: socket.id,
      // You can add more user information here, such as name, location, etc.
    };
    const existingUserIndex = connectedUsers.findIndex((user) => {
      return user.id === Id;
    });
  
    if (existingUserIndex !== -1) {
      // Remove the existing users's record
      connectedUsers.splice(existingUserIndex, 1);
    }
    connectedUsers.push(userInfo);
    console.log(connectedUsers);
    console.log('User connected:', Id, socket.id);
  }


  /**
  * Location Update
  */
  socket.on('updateLocation', (data) => {
    console.log("location update event call for driver");
    const Id = data.id;
    const headers = {
      'Content-Type': 'application/json',
      'Authorization': 'Bearer ' + data.auth_token,
    }
    console.log(data.auth_token);
    const postData = JSON.stringify({
      'latitude': data.latitude,
      'longitude': data.longitude,
    });
    axios.post(host + '/api/v1/update_location', postData, {
      headers: headers,
    })

      .then((response) => {
        console.log(response.data.user);


        if (response.status == 200) {
          const resultData = JSON.stringify({
            'latitude': data.latitude,
            'longitude': data.longitude,
            'status': 1
          });
          if (response.data.user > 0) {
            connectedUsers.forEach((user) => {
              if (response.data.user == user.id) {
                console.log(user.socketId);
                io.to(user.socketId).emit('location_update', resultData);
              }
            })
          }

          socket.emit("location_update", resultData);
        }
        else {
          const resultData = JSON.stringify({
            'latitude': data.latitude,
            'longitude': data.longitude,
            'status': 0
          });
          socket.emit("location_update", resultData);
        }

      })
      .catch((error) => {
        console.error(`problem with request: ${error}`);
        const resultData = JSON.stringify({
          'latitude': data.latitude,
          'longitude': data.longitude,
          'status': 0
        });
        socket.emit("location_update", resultData);
      })
  });

  /**
  * Nearby Driver
  */
  socket.on('nearbyDriver', (data) => {
    console.log("get near by driver  event call for customer");
    const headers = {
      'Content-Type': 'application/json',
      'Accept': 'application/json',
      'Authorization': 'Bearer ' + data.auth_token,
    }

    const postData = JSON.stringify({
      'latitude': data.latitude,
      'longitude': data.longitude,
    });

    axios.post(host + '/api/v1/get_nearby_drivers', postData, {
      headers: headers,
    }).then((response) => {
      // console.log(response.status);
      // var response_data = response.data;
      if (response.status == 200) {
        // let responseData = response_data.responseData;
        console.log("get near by driver  event emit for customer");
        socket.emit("driver_list_" + response.data.data.user_id, response.data);
      }
      // if (response_data.responseCode == 400) {
      //   let responseData = response_data.responseData;
      //   socket.emit("driver_list_" + responseData.user_id, response_data);
      // }
    })
      .catch((error) => {
        console.error(`problem with request: ${error}`);
      })
  });

  /**
  * Search Driver
  */


  // Handle booking requests from customers
  socket.on('bookingRequest', (bookingData) => {
    console.log('Received booking request:', bookingData);

    // Find nearby drivers having the same vehicle as requested
    const nearbyDrivers = connectedDrivers.filter(driver => driver.vehicle === bookingData.requestedVehicle);

    // Emit the booking data to nearby drivers
    for (const driver of nearbyDrivers) {
      io.to(driver.socketId).emit('bookingRequest', bookingData);
    }
  });

  socket.on('disconnect', () => {
    const existingDriverIndex = connectedDrivers.findIndex((driver) => {
      return driver.socketId === socket.id;
    });
  
    if (existingDriverIndex !== -1) {
      // Remove the existing driver's record
      connectedDrivers.splice(existingDriverIndex, 1);
    }
    const existingUserIndex = connectedUsers.findIndex((user) => {
      return user.socketId === socket.id;
    });
  
    if (existingUserIndex !== -1) {
      // Remove the existing users's record
      connectedUsers.splice(existingUserIndex, 1);
    }
   
    console.log('Disconnect');
    console.log(socket.id);
    console.log(connectedDrivers);
    console.log(connectedUsers);
  })
});

server.listen(port, () => {
  console.log(`Server listening on port ${port}`);
});

(async () => {
  //redis Connection
  var redisClient = redis.createClient({
    host: process.env.REDIS_HOST,
    no_ready_check: false,
    port: process.env.REDIS_PORT,
    password: process.env.REDIS_PASSWORD,
  });

  // console.log(redisClient);
  // await redisClient.connect();
  redisClient.subscribe(['location_update_data', 'get_customer_request', 'get_driver_bid_request', 'get_bid_request', 'driver_accept_bid', 'user_accept_bid','no_booking_response']);
  redisClient.on("message", function (channel, data) {

    if (channel === 'location_update_data') {
      let rawdata = JSON.parse(data);
      // console.log(rawdata)
      let finaldata = JSON.stringify(rawdata);
      // console.log(rawdata);
      console.log(finaldata);
      // io.sockets.emit("updateLocation" ,"hello");
    }

    if (channel === 'get_customer_request') {

      let rawdata = JSON.parse(data);
      let finaldata = JSON.stringify(rawdata);
      idsToCheck = rawdata.drivers;

      // Loop through the connectedDrivers array
      connectedDrivers.forEach((driver) => {

        idsToCheck.filter((data) => {
          if (data.id == driver.id) {

            // Emit a message to the corresponding socketId

            console.log(driver.socketId);
            io.to(driver.socketId).emit('messageToDriver', rawdata.bookingdata);
          }
        });


      })
      // io.sockets.emit("getCustomerRequest", finaldata);
    }

    if (channel === 'get_bid_request') {

      let rawdata = JSON.parse(data);
      let finaldata = JSON.stringify(rawdata);
      idsToCheck = rawdata.users;

      // Loop through the connectedDrivers array
      connectedUsers.forEach((user) => {

        // idsToCheck.filter((data) => {
        if (rawdata.user == user.id) {

          // Emit a message to the corresponding socketId

          console.log(user.socketId);
          io.to(user.socketId).emit('messageToCustomer', rawdata.bookingdata);
        }
        // });


      })
      // io.sockets.emit("getCustomerRequest", finaldata);
    }

    if (channel === 'get_driver_bid_request') {

      let rawdata = JSON.parse(data);
      let finaldata = JSON.stringify(rawdata);
      idsToCheck = rawdata.driver;

      // Loop through the connectedDrivers array
      connectedDrivers.forEach((driver) => {

        // idsToCheck.filter((data) => {
        if (rawdata.driver == driver.id) {

          // Emit a message to the corresponding socketId

          console.log(driver.socketId);
          io.to(driver.socketId).emit('messageToDriver', rawdata.bookingdata);
        }
        // });


      })
      // io.sockets.emit("getCustomerRequest", finaldata);
    }

    if (channel === 'driver_accept_bid') {

      let rawdata = JSON.parse(data);
      let finaldata = JSON.stringify(rawdata);
      idsToCheck = rawdata.driver;

      // Loop through the connectedDrivers array
      connectedDrivers.forEach((driver) => {

        // idsToCheck.filter((data) => {
        if (rawdata.driver == driver.id) {

          // Emit a message to the corresponding socketId

          console.log(driver.socketId);
          io.to(driver.socketId).emit('statusToDriver', rawdata.bookingdata);
        }
        // });


      })
      // io.sockets.emit("getCustomerRequest", finaldata);
    }

    if (channel === 'user_accept_bid') {

      let rawdata = JSON.parse(data);
      let finaldata = JSON.stringify(rawdata);
      idsToCheck = rawdata.users;

      // Loop through the connectedDrivers array
      connectedUsers.forEach((user) => {

        // idsToCheck.filter((data) => {
        if (rawdata.user == user.id) {

          // Emit a message to the corresponding socketId

          console.log(user.socketId);
          io.to(user.socketId).emit('statusToCustomer', rawdata.bookingdata);
        }
        // });


      })
      // io.sockets.emit("getCustomerRequest", finaldata);
    }

    if (channel === 'no_booking_response') {

      let rawdata = JSON.parse(data);
      let finaldata = JSON.stringify(rawdata);
      idsToCheck = rawdata.users;

      // Loop through the connectedDrivers array
      connectedUsers.forEach((user) => {

        // idsToCheck.filter((data) => {
        if (rawdata.user == user.id) {

          // Emit a message to the corresponding socketId

          console.log(user.socketId);
          io.to(user.socketId).emit('bookingResponse', rawdata.bookingdata);
        }
        // });


      })
      // io.sockets.emit("getCustomerRequest", finaldata);
    }



  });


  redisClient.on('disconnect', function () {
    console.log("Disconnected");
    redisClient.quit();
  });

})();