<?php

namespace Database\Seeders;

use Exception;
use App\Models\City;
use App\Models\State;
use App\Models\Country;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class CountriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        try {

            DB::beginTransaction();
            
            Schema::disableForeignKeyConstraints();

            Country::truncate();
            State::truncate();
            City::truncate();

            $countriesJSON = resource_path('/assets/countries.json');
            $countriesJSON = collect(json_decode(file_get_contents($countriesJSON), true));

            foreach ($countriesJSON->chunk(20) as $countries) {
                
                foreach ($countries as $country) {
                    
                    $countryData = Country::create([
                        'name' => $country['name'],
                        'code' => $country['iso3'],
                        'isd_code' => '+'.$country['phone_code'],
                        'currency_code' => $country['currency'],
                        'emoji' => $country['emoji'],
                        'is_active' => 1,
                    ]);

                    foreach ($country['states'] as $state) {

                        $stateData = State::create([
                            'country_id'=> $countryData->getKey(),
                            'name' => $state['name'],
                            'code' => $state['state_code'],
                            'is_active' => 1,
                        ]);

                        foreach ($state['cities'] as $city) {

                            City::create([
                                'state_id'=> $stateData->getKey(),
                                'name' => $city['name'],
                                'is_active' => 1,
                            ]);
                        }
                    }
                }
            }

            Schema::enableForeignKeyConstraints();

            DB::commit();
            echo 'OK';
        } catch (Exception $e){
            DB::rollback();
            echo $e->getMessage();
        }
    }
}
